/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.init;

import com.jkvin114.displaydelight.block.DrinkBlock;
import com.jkvin114.displaydelight.block.EmptyPlateBlock;
import com.jkvin114.displaydelight.block.EmptySmallPlateBlock;
import com.jkvin114.displaydelight.block.FoodBlock;
import com.jkvin114.displaydelight.block.WideFoodBlock;
import com.jkvin114.displaydelight.init.DisplayItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DisplayBlocks {
    public static List<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"displaydelight");
    public static final RegistryObject<Block> PLATE = REGISTRY.register("food_plate", () -> new EmptyPlateBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> SMALL_PLATE = REGISTRY.register("small_food_plate", () -> new EmptySmallPlateBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> GLOW_BERRY_CUSTARD = DisplayBlocks.createDrinkFoodBlock("glow_berry_custard");
    public static final RegistryObject<Block> FRUIT_SALAD = DisplayBlocks.createFoodBlock("fruit_salad");
    public static final RegistryObject<Block> COOKED_RICE = DisplayBlocks.createFoodBlock("cooked_rice");
    public static final RegistryObject<Block> MIXED_SALAD = DisplayBlocks.createFoodBlock("mixed_salad");
    public static final RegistryObject<Block> BEEF_STEW = DisplayBlocks.createFoodBlock("beef_stew");
    public static final RegistryObject<Block> CHICKEN_SOUP = DisplayBlocks.createFoodBlock("chicken_soup");
    public static final RegistryObject<Block> VEGETABLE_SOUP = DisplayBlocks.createFoodBlock("vegetable_soup");
    public static final RegistryObject<Block> FISH_STEW = DisplayBlocks.createFoodBlock("fish_stew");
    public static final RegistryObject<Block> FRIED_RICE = DisplayBlocks.createFoodBlock("fried_rice");
    public static final RegistryObject<Block> PUMPKIN_SOUP = DisplayBlocks.createFoodBlock("pumpkin_soup");
    public static final RegistryObject<Block> BAKED_COD_STEW = DisplayBlocks.createFoodBlock("baked_cod_stew");
    public static final RegistryObject<Block> NOODLE_SOUP = DisplayBlocks.createFoodBlock("noodle_soup");
    public static final RegistryObject<Block> BONE_BROTH = DisplayBlocks.createFoodBlock("bone_broth");
    public static final RegistryObject<Block> BACON_AND_EGGS = DisplayBlocks.createWideFoodBlock("bacon_and_eggs");
    public static final RegistryObject<Block> PASTA_WITH_MEATBALLS = DisplayBlocks.createWideFoodBlock("pasta_with_meatballs");
    public static final RegistryObject<Block> PASTA_WITH_MUTTON_CHOP = DisplayBlocks.createWideFoodBlock("pasta_with_mutton_chop");
    public static final RegistryObject<Block> ROASTED_MUTTON_CHOPS = DisplayBlocks.createWideFoodBlock("roasted_mutton_chops");
    public static final RegistryObject<Block> STEAK_AND_POTATOES = DisplayBlocks.createWideFoodBlock("steak_and_potatoes");
    public static final RegistryObject<Block> VEGETABLE_NOODLES = DisplayBlocks.createWideFoodBlock("vegetable_noodles");
    public static final RegistryObject<Block> RATATOUILLE = DisplayBlocks.createWideFoodBlock("ratatouille");
    public static final RegistryObject<Block> SQUID_INK_PASTA = DisplayBlocks.createWideFoodBlock("squid_ink_pasta");
    public static final RegistryObject<Block> GRILLED_SALMON = DisplayBlocks.createWideFoodBlock("grilled_salmon");
    public static final RegistryObject<Block> MUSHROOM_RICE = DisplayBlocks.createWideFoodBlock("mushroom_rice");
    public static final RegistryObject<Block> ROAST_CHICKEN = DisplayBlocks.createFoodBlock("roast_chicken");
    public static final RegistryObject<Block> STUFFED_PUMPKIN = DisplayBlocks.createFoodBlock("stuffed_pumpkin");
    public static final RegistryObject<Block> HONEY_GLAZED_HAM = DisplayBlocks.createFoodBlock("honey_glazed_ham");
    public static final RegistryObject<Block> SHEPHEREDS_PIE = DisplayBlocks.createFoodBlock("shepherds_pie");
    public static final RegistryObject<Block> APPLE_CIDER = DisplayBlocks.createDrinkFoodBlock("apple_cider");
    public static final RegistryObject<Block> MELON_JUICE = DisplayBlocks.createDrinkFoodBlock("melon_juice");
    public static final RegistryObject<Block> HOT_COCOA = DisplayBlocks.createDrinkFoodBlock("hot_cocoa");
    public static final RegistryObject<Block> MUSHROOM_STEW = DisplayBlocks.createFoodBlock("mushroom_stew");
    public static final RegistryObject<Block> RABBIT_STEW = DisplayBlocks.createFoodBlock("rabbit_stew");
    public static final RegistryObject<Block> BEETROOT_STEW = DisplayBlocks.createFoodBlock("beetroot_soup");

    public static List<Block> getAll() {
        return blocks.stream().map(RegistryObject::get).toList();
    }

    private static BlockBehaviour.Properties baseProps() {
        return BlockBehaviour.Properties.m_284310_().m_60955_().m_60966_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283808_);
    }

    public static RegistryObject<Block> createDrinkFoodBlock(String name) {
        RegistryObject block = REGISTRY.register(name, () -> new DrinkBlock(DisplayBlocks.baseProps().m_60918_(SoundType.f_56744_)));
        DisplayItems.registerBlockItem((RegistryObject<Block>)block);
        blocks.add((RegistryObject<Block>)block);
        return block;
    }

    public static RegistryObject<Block> createWideFoodBlock(String name) {
        RegistryObject block = REGISTRY.register(name, () -> new WideFoodBlock(DisplayBlocks.baseProps().m_60918_(SoundType.f_56736_)));
        blocks.add((RegistryObject<Block>)block);
        DisplayItems.registerBlockItem((RegistryObject<Block>)block);
        return block;
    }

    public static RegistryObject<Block> createFoodBlock(String name) {
        RegistryObject block = REGISTRY.register(name, () -> new FoodBlock(DisplayBlocks.baseProps().m_60918_(SoundType.f_56736_)));
        blocks.add((RegistryObject<Block>)block);
        DisplayItems.registerBlockItem((RegistryObject<Block>)block);
        return block;
    }
}

