/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland.utils;

import cool.bot.dewdropfarmland.DewDropFarmland;
import cool.bot.dewdropfarmland.utils.SeasonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.LatticeBlock;
import net.satisfy.vinery.core.block.PaleStemBlock;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;

public class VineryCompat {
    public static boolean isPaleStemFertile(BlockState state, Level level, BlockPos pos) {
        boolean isTaiga;
        Season season = SeasonHelper.getSeasonState((Level)level).getSeason();
        Holder biome = level.m_204166_(pos);
        boolean isSavanna = state.m_61143_((Property)PaleStemBlock.GRAPE) == GrapeTypeRegistry.SAVANNA_WHITE || state.m_61143_((Property)PaleStemBlock.GRAPE) == GrapeTypeRegistry.SAVANNA_RED;
        boolean bl = isTaiga = state.m_61143_((Property)PaleStemBlock.GRAPE) == GrapeTypeRegistry.TAIGA_RED || state.m_61143_((Property)PaleStemBlock.GRAPE) == GrapeTypeRegistry.TAIGA_WHITE;
        if (pos.m_123342_() < ModConfig.fertility.undergroundFertilityLevel && !level.m_45527_(pos)) {
            return true;
        }
        if (biome.m_203656_(ModTags.Biomes.INFERTILE_BIOMES)) {
            return false;
        }
        if (ModConfig.fertility.seasonalCrops && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) && ModConfig.seasons.isDimensionWhitelisted(level.m_46472_())) {
            if (biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)) {
                return isSavanna;
            }
            if (!((Biome)biome.m_203334_()).m_198906_(pos)) {
                return isTaiga;
            }
            if (season == Season.SPRING && !isTaiga) {
                return true;
            }
            if (season == Season.SUMMER && isSavanna) {
                return true;
            }
            if (season == Season.AUTUMN && !isSavanna && !isTaiga) {
                return true;
            }
            return season == Season.WINTER && isTaiga;
        }
        return true;
    }

    public static boolean isLatticeFertile(Level level, BlockPos pos) {
        Season season = SeasonHelper.getSeasonState((Level)level).getSeason();
        Holder biome = level.m_204166_(pos);
        if (pos.m_123342_() < ModConfig.fertility.undergroundFertilityLevel && !level.m_45527_(pos)) {
            return true;
        }
        if (biome.m_203656_(ModTags.Biomes.INFERTILE_BIOMES)) {
            return false;
        }
        if (ModConfig.fertility.seasonalCrops && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) && ModConfig.seasons.isDimensionWhitelisted(level.m_46472_())) {
            if (biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)) {
                return true;
            }
            return season == Season.SUMMER;
        }
        return true;
    }

    public static void handlePaleStemGrowth(BlockState state, ServerLevel world, BlockPos pos) {
        int i;
        PaleStemBlock block = (PaleStemBlock)state.m_60734_();
        if (!block.isMature(state) && block.hasTrunk((Level)world, pos) && (Integer)state.m_61143_((Property)PaleStemBlock.AGE) > 0 && world.m_45524_(pos, 0) >= 9 && (i = ((Integer)state.m_61143_((Property)PaleStemBlock.AGE)).intValue()) < 4) {
            boolean canGrow = true;
            if (DewDropFarmland.SERENE_SEASONS_INSTALLED) {
                boolean fertile = VineryCompat.isPaleStemFertile(state, (Level)world, pos);
                boolean bl = canGrow = !ModConfig.fertility.seasonalCrops || fertile || SeasonUtils.isGlassAboveBlock(world, pos);
            }
            if (canGrow) {
                world.m_7731_(pos, block.withAge(state, i + 1, (GrapeType)state.m_61143_((Property)PaleStemBlock.GRAPE)), 2);
            }
        }
    }

    public static void handleLatticeGrowth(BlockState state, ServerLevel world, BlockPos pos) {
        LatticeBlock block = (LatticeBlock)state.m_60734_();
        if (!block.isMature(state)) {
            boolean canGrow = true;
            if (DewDropFarmland.SERENE_SEASONS_INSTALLED) {
                boolean fertile = VineryCompat.isLatticeFertile((Level)world, pos);
                boolean bl = canGrow = !ModConfig.fertility.seasonalCrops || fertile || SeasonUtils.isGlassAboveBlock(world, pos);
            }
            if (canGrow) {
                int age = (Integer)state.m_61143_((Property)LatticeBlock.AGE);
                GrapeType type = (GrapeType)state.m_61143_((Property)LatticeBlock.GRAPE);
                BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)LatticeBlock.AGE, (Comparable)Integer.valueOf(age + 1))).m_61124_((Property)LatticeBlock.GRAPE, (Comparable)type);
                world.m_7731_(pos, newState, 2);
                BlockEntity be = world.m_7702_(pos);
                if (be instanceof LatticeBlockEntity) {
                    LatticeBlockEntity lattice = (LatticeBlockEntity)be;
                    lattice.setAge(age + 1);
                    lattice.setGrapeType(type);
                }
            }
        }
    }
}

