/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland.utils;

import com.baisylia.culturaldelights.block.custom.CornBlock;
import com.baisylia.culturaldelights.block.custom.CornUpperBlock;
import com.rosemods.windswept.common.block.WildBerryBushBlock;
import cool.bot.dewdropfarmland.DewDropFarmland;
import cool.bot.dewdropfarmland.block.CustomStemBlock;
import cool.bot.dewdropfarmland.tag.SturdyFarmlandBlockTags;
import cool.bot.dewdropfarmland.utils.ModGrowthCompat;
import cool.bot.dewdropfarmland.utils.SeasonUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlaxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.ribs.vintagedelight.block.custom.GearoBerryBushBlock;
import net.satisfy.vinery.core.block.GrapeBush;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import vectorwing.farmersdelight.common.block.BuddingTomatoBlock;
import vectorwing.farmersdelight.common.block.RiceBlock;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;

public class CropHandlerUtils {
    public static int getFertilizerIncrease(int age, int maxAge, BlockState farmland) {
        int increase = 1;
        if (age == 0) {
            if (farmland.m_204336_(SturdyFarmlandBlockTags.WEAK_FERTILIZED_FARMLAND)) {
                increase = 2;
            }
            if (farmland.m_204336_(SturdyFarmlandBlockTags.STRONG_FERTILIZED_FARMLAND)) {
                increase = 3;
            }
            if (farmland.m_204336_(SturdyFarmlandBlockTags.HYPER_FERTILIZED_FARMLAND)) {
                increase = 4;
            }
        }
        return Math.min(increase, maxAge);
    }

    public static void growSweetBerryBush(ServerLevel level, SweetBerryBushBlock bushBlock, BlockPos pos, BlockState farmland) {
        int bushAge = (Integer)level.m_8055_(pos).m_61143_((Property)SweetBerryBushBlock.f_57244_);
        if (bushAge < 3) {
            level.m_7731_(pos, (BlockState)bushBlock.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(bushAge + CropHandlerUtils.getFertilizerIncrease(bushAge, 3, farmland))), 2);
        }
    }

    public static void handleCropGrowth(BlockState crop, ServerLevel level, BlockPos abovePos, BlockState farmland, RandomSource random) {
        Block aboveBlock = crop.m_60734_();
        if (aboveBlock instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)aboveBlock;
            if (!(cropBlock.m_52307_(crop) || DewDropFarmland.SUPPLEMENTARIES_INSTALLED && cropBlock instanceof FlaxBlock)) {
                int growthAmount = CropHandlerUtils.getFertilizerIncrease(cropBlock.m_52305_(crop), cropBlock.m_7419_(), farmland);
                BlockState newState = cropBlock.m_52289_(cropBlock.m_52305_(crop) + growthAmount);
                level.m_7731_(abovePos, newState, 2);
                if (DewDropFarmland.FARMERS_DELIGHT_INSTALLED && cropBlock instanceof TomatoVineBlock) {
                    TomatoVineBlock tomatoVineBlock = (TomatoVineBlock)cropBlock;
                    BlockPos aboveCropPos = abovePos.m_7918_(0, 1, 0);
                    BlockState tomatoVine = level.m_8055_(aboveCropPos);
                    Block block = tomatoVine.m_60734_();
                    if (block instanceof TomatoVineBlock) {
                        TomatoVineBlock aboveTomatoVineBlock = (TomatoVineBlock)block;
                        if (!aboveTomatoVineBlock.m_52307_(tomatoVine)) {
                            newState = (BlockState)aboveTomatoVineBlock.m_52289_(aboveTomatoVineBlock.m_52305_(crop) + 1).m_61124_((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(true));
                            level.m_7731_(aboveCropPos, newState, 2);
                        }
                    } else {
                        tomatoVineBlock.attemptRopeClimb(level, abovePos, random);
                    }
                }
            } else if (DewDropFarmland.SUPPLEMENTARIES_INSTALLED && cropBlock instanceof FlaxBlock) {
                FlaxBlock flaxBlock = (FlaxBlock)cropBlock;
                flaxBlock.growCropBy((Level)level, abovePos, crop, CropHandlerUtils.getFertilizerIncrease(cropBlock.m_52305_(crop), cropBlock.m_7419_(), farmland));
            }
        } else if (aboveBlock instanceof SweetBerryBushBlock) {
            SweetBerryBushBlock sweetBerryBushBlock = (SweetBerryBushBlock)aboveBlock;
            CropHandlerUtils.growSweetBerryBush(level, sweetBerryBushBlock, abovePos, farmland);
        } else if (DewDropFarmland.WINDSWEPT_INSTALLED && aboveBlock instanceof WildBerryBushBlock) {
            ModGrowthCompat.growWildBerryBush(level, aboveBlock, abovePos, farmland);
        } else if (DewDropFarmland.VINERY_INSTALLED && aboveBlock instanceof GrapeBush) {
            ModGrowthCompat.growGrapeBush(level, aboveBlock, abovePos, farmland);
        } else if (DewDropFarmland.VINTAGEDELIGHT_INSTALLED && aboveBlock instanceof GearoBerryBushBlock) {
            ModGrowthCompat.growGearoBerryBush(level, aboveBlock, abovePos, farmland);
        } else if (DewDropFarmland.CULTURAL_DELIGHTS_INSTALLED && aboveBlock instanceof CornBlock) {
            ModGrowthCompat.growCulturalDelightCorn(level, aboveBlock, abovePos, CornBlock.AGE, CornUpperBlock.f_52244_, farmland);
        } else if (DewDropFarmland.FARMERS_DELIGHT_INSTALLED && aboveBlock instanceof RiceBlock) {
            ModGrowthCompat.growFarmersDelightRice(level, aboveBlock, abovePos, farmland);
        } else if (aboveBlock instanceof CustomStemBlock) {
            CustomStemBlock stemBlock = (CustomStemBlock)aboveBlock;
            int stemAge = stemBlock.getAge(crop);
            if (stemAge == 7) {
                stemBlock.placeFruit(level, abovePos);
            } else {
                int growthAmount = CropHandlerUtils.getFertilizerIncrease(stemAge, 7, farmland);
                BlockState newState = stemBlock.getStateForAge(stemAge + growthAmount);
                level.m_7731_(abovePos, newState, 2);
            }
        } else if (aboveBlock instanceof PitcherCropBlock) {
            PitcherCropBlock pitcherCropBlock = (PitcherCropBlock)aboveBlock;
            int pitcherAge = (Integer)level.m_8055_(abovePos).m_61143_((Property)PitcherCropBlock.f_276478_);
            int growthAmount = CropHandlerUtils.getFertilizerIncrease(pitcherAge, 4, farmland);
            for (int i = 0; i < growthAmount; ++i) {
                pitcherCropBlock.m_214148_(level, random, abovePos, level.m_8055_(abovePos));
            }
        } else if (DewDropFarmland.FARMERS_DELIGHT_INSTALLED && aboveBlock instanceof BuddingTomatoBlock) {
            BuddingTomatoBlock tomatoBlock = (BuddingTomatoBlock)aboveBlock;
            tomatoBlock.growPastMaxAge(crop, level, abovePos, random);
        }
    }

    public static void growCactusLike(ServerLevel level, Block block, BlockPos pos, BlockState farmland) {
        int growth = CropHandlerUtils.getFertilizerIncrease(0, 2, farmland);
        for (int i = 1; i < 3; ++i) {
            if (!level.m_8055_(pos.m_6630_(i)).m_60713_(Blocks.f_50016_)) continue;
            if (block instanceof SugarCaneBlock && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_6630_(i), (BlockState)block.m_49966_(), (boolean)true)) {
                level.m_46597_(pos.m_6630_(i), block.m_49966_());
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_6630_(i), (BlockState)block.m_49966_());
                level.m_7731_(pos.m_6630_(i), block.m_49966_(), 4);
            } else if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_6630_(i), (BlockState)block.m_49966_(), (boolean)true)) {
                level.m_46597_(pos.m_6630_(i), block.m_49966_());
                level.m_213960_(block.m_49966_(), pos.m_6630_(i - 1), block, pos.m_6630_(i), false);
            }
            if (growth <= 1) break;
            --growth;
        }
    }

    public static void handleSandCropGrowth(BlockState crop, ServerLevel level, BlockPos abovePos, BlockState farmland, RandomSource random) {
        SugarCaneBlock sugarCaneBlock;
        Block aboveBlock = crop.m_60734_();
        if (aboveBlock instanceof CactusBlock) {
            CactusBlock cactusBlock = (CactusBlock)aboveBlock;
            CropHandlerUtils.growCactusLike(level, (Block)cactusBlock, abovePos, farmland);
        } else if (aboveBlock instanceof SugarCaneBlock && (sugarCaneBlock = (SugarCaneBlock)aboveBlock).m_7898_(crop, (LevelReader)level, abovePos)) {
            CropHandlerUtils.growCactusLike(level, (Block)sugarCaneBlock, abovePos, farmland);
        }
    }

    public static boolean inRange(Integer range, BlockPos pos, BlockPos center) {
        return Math.abs(pos.m_123341_() - center.m_123341_()) < range + 1 && Math.abs(pos.m_123343_() - center.m_123343_()) < range + 1;
    }

    public static boolean isNearSprinkler(LevelReader level, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-4, 0, -4), (BlockPos)pPos.m_7918_(4, 1, 4))) {
            if (CropHandlerUtils.inRange(1, blockpos, pPos) && level.m_8055_(blockpos).m_204336_(SturdyFarmlandBlockTags.SPRINKLER_TIER_1)) {
                return true;
            }
            if (CropHandlerUtils.inRange(2, blockpos, pPos) && level.m_8055_(blockpos).m_204336_(SturdyFarmlandBlockTags.SPRINKLER_TIER_2)) {
                return true;
            }
            if (CropHandlerUtils.inRange(3, blockpos, pPos) && level.m_8055_(blockpos).m_204336_(SturdyFarmlandBlockTags.SPRINKLER_TIER_3)) {
                return true;
            }
            if (!CropHandlerUtils.inRange(4, blockpos, pPos) || !level.m_8055_(blockpos).m_204336_(SturdyFarmlandBlockTags.SPRINKLER_TIER_4)) continue;
            return true;
        }
        return false;
    }

    public static void growCropsInRadius(ServerLevel level, BlockPos centerPos, RandomSource random, int radius) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(centerPos.m_123341_() - radius, centerPos.m_123342_(), centerPos.m_123343_() - radius), (BlockPos)new BlockPos(centerPos.m_123341_() + radius, centerPos.m_123342_(), centerPos.m_123343_() + radius))) {
            CropHandlerUtils.growCrop(level.m_8055_(pos), level, pos, level.m_8055_(centerPos.m_7495_()), random, false);
        }
    }

    public static void growCrop(BlockState crop, ServerLevel level, BlockPos abovePos, BlockState farmland, RandomSource random, Boolean sandy) {
        CropHandlerUtils.growCrop(crop, level, abovePos, farmland, random, sandy, false);
    }

    public static void growCrop(BlockState crop, ServerLevel level, BlockPos abovePos, BlockState farmland, RandomSource random, Boolean sandy, Boolean gardenPot) {
        boolean canGrow = true;
        if (DewDropFarmland.SERENE_SEASONS_INSTALLED) {
            ResourceLocation fertileKey = ForgeRegistries.BLOCKS.getKey((Object)crop.m_60734_());
            boolean fertile = ModFertility.isCropFertile((String)(fertileKey != null ? fertileKey.toString() : null), (Level)level, (BlockPos)abovePos);
            boolean bl = canGrow = !ModConfig.fertility.seasonalCrops || fertile || SeasonUtils.isGlassAboveBlock(level, abovePos) || gardenPot != false && !level.m_45527_(abovePos.m_7494_());
        }
        if (canGrow) {
            if (sandy.booleanValue()) {
                CropHandlerUtils.handleSandCropGrowth(crop, level, abovePos, farmland, random);
            } else {
                CropHandlerUtils.handleCropGrowth(crop, level, abovePos, farmland, random);
            }
        }
    }
}

