/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland.block;

import cool.bot.botslib.util.RNG;
import cool.bot.botslib.util.Util;
import cool.bot.dewdropfarmland.Config;
import cool.bot.dewdropfarmland.utils.CropHandlerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public class GardenPotBlock
extends FarmBlock
implements IForgeBlock {
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)GardenPotBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), (VoxelShape)GardenPotBlock.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final BooleanProperty DELUXE = BooleanProperty.m_61465_((String)"deluxe");

    public GardenPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DELUXE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{DELUXE});
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return null;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (Config.rainWatering || Config.dailyReset) {
            level.m_186460_(pos, (Block)this, 10);
            if (level.m_46758_(pos.m_7494_()) && Config.rainWatering) {
                Util.setMoist((ServerLevel)level, (BlockPos)pos);
            }
            if (level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_) {
                Util.setMoist((ServerLevel)level, (BlockPos)pos);
            }
            if (!Config.dailyReset || !((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46223_()) {
                return;
            }
            long dayTime = level.m_46468_() % 24000L;
            if (dayTime >= (long)Config.dailyTimeMin && dayTime < (long)(Config.dailyTimeMin + 10)) {
                BlockState farmland = level.m_8055_(pos);
                boolean hydrated = Util.isMoistWaterable((ServerLevel)level, (BlockPos)pos);
                BlockPos abovePos = pos.m_7494_();
                BlockState crop = level.m_8055_(abovePos);
                if (hydrated && !(crop.m_60734_() instanceof AirBlock)) {
                    CropHandlerUtils.growCrop(crop, level, abovePos, farmland, random, false, true);
                }
                if (RNG.mc_ihundo((RandomSource)random, (int)Config.dailyDryChance) && !((Boolean)farmland.m_61143_((Property)DELUXE)).booleanValue()) {
                    Util.setDry((ServerLevel)level, (BlockPos)pos);
                }
            }
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (!level.m_5776_() && (Config.rainWatering || Config.dailyReset)) {
            ((ServerLevel)level).m_186460_(pos, (Block)this, 10);
        }
        super.onBlockStateChange(level, pos, oldState, newState);
    }
}

