/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="dew_drop_farmland_growth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue NO_TRAMPLE = BUILDER.comment("Whether to stop crop trampling").define("noTrample", true);
    private static final ForgeConfigSpec.BooleanValue NO_RANDOM_TICK = BUILDER.comment("Whether to stop random ticks (Water from source blocks and moisture decay)").define("noRandomTick", true);
    private static final ForgeConfigSpec.BooleanValue STURDY_FARMLAND = BUILDER.comment("When enabled, farmland will not check for blocks above it, and can be built on top of without turning to dirt").define("sturdyFarmland", true);
    private static final ForgeConfigSpec.BooleanValue SPLASH_POTION_WATERING = BUILDER.comment("If splash water potions can be used to moisten farmland").define("splashPotionWatering", true);
    private static final ForgeConfigSpec.IntValue SPLASH_WATER_AREA = BUILDER.comment("The range of splash water bottles for watering, 0 to water only the block hit").defineInRange("splashWaterArea", 1, 0, 8);
    private static final ForgeConfigSpec.BooleanValue BUCKET_WATERING = BUILDER.comment("If buckets can be used to moisten farmland").define("bucketWatering", true);
    private static final ForgeConfigSpec.BooleanValue BOTTLE_WATERING = BUILDER.comment("If bottles can be used to moisten farmland").define("bottleWatering", true);
    private static final ForgeConfigSpec.BooleanValue RAIN_WATERING = BUILDER.comment("If rain will moisten farmland").define("rainWatering", true);
    private static final ForgeConfigSpec.BooleanValue DAILY_RESET = BUILDER.comment("If the farmland will decay daily").define("dailyReset", true);
    private static final ForgeConfigSpec.IntValue DAILY_TIME_MIN = BUILDER.comment("The time of day daily reset logic will occur (within 10 ticks)").defineInRange("dailyTimeMin", 5, 0, 24000);
    private static final ForgeConfigSpec.IntValue DAILY_DRY_CHANCE = BUILDER.comment("The chance that farmland will become dry").defineInRange("dailyDryChance", 100, 0, 100);
    private static final ForgeConfigSpec.IntValue DAILY_DECAY_CHANCE = BUILDER.comment("The chance that dry farmland will decay into dirt").defineInRange("dailyDecayChance", 100, 0, 100);
    private static final ForgeConfigSpec.BooleanValue SHOVEL_REVERTING = BUILDER.comment("If shovels can turn farmland to dirt when right clicking").define("shovelReverting", true);
    private static final ForgeConfigSpec.BooleanValue CHECK_SPRINKLERS = BUILDER.comment("If crops should check for blocks with sprinkler tags to prevent drying").define("checkSprinklers", true);
    private static final ForgeConfigSpec.BooleanValue STRICT_GREENHOUSES = BUILDER.comment("Crops will not factor in greenhouse glass if a #dewdrop:waterable farmland is between them ").define("strictGreenhouses", false);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean noTrample;
    public static boolean splashPotionWatering;
    public static int splashWaterArea;
    public static boolean bucketWatering;
    public static boolean bottleWatering;
    public static boolean rainWatering;
    public static boolean dailyReset;
    public static int dailyTimeMin;
    public static int dailyDryChance;
    public static int dailyDecayChance;
    public static boolean sturdyFarmland;
    public static boolean noRandomTick;
    public static boolean shovelReverting;
    public static boolean checkSprinklers;
    public static boolean strictGreenhouses;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        noTrample = (Boolean)NO_TRAMPLE.get();
        splashPotionWatering = (Boolean)SPLASH_POTION_WATERING.get();
        splashWaterArea = (Integer)SPLASH_WATER_AREA.get();
        bucketWatering = (Boolean)BUCKET_WATERING.get();
        bottleWatering = (Boolean)BOTTLE_WATERING.get();
        rainWatering = (Boolean)RAIN_WATERING.get();
        dailyReset = (Boolean)DAILY_RESET.get();
        dailyTimeMin = (Integer)DAILY_TIME_MIN.get();
        dailyDryChance = (Integer)DAILY_DRY_CHANCE.get();
        dailyDecayChance = (Integer)DAILY_DECAY_CHANCE.get();
        sturdyFarmland = (Boolean)STURDY_FARMLAND.get();
        noRandomTick = (Boolean)NO_RANDOM_TICK.get();
        shovelReverting = (Boolean)SHOVEL_REVERTING.get();
        checkSprinklers = (Boolean)CHECK_SPRINKLERS.get();
        strictGreenhouses = (Boolean)STRICT_GREENHOUSES.get();
    }
}

