/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.filter;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_logistics.logistics.generic.FluidGenericStack;
import ru.zznty.create_factory_logistics.logistics.generic.GenericAttribute;

@Mixin(value={FilterItemStack.AttributeFilterItemStack.class})
public class GenericAttributeFilterItemStackMixin
extends FilterItemStack {
    @Shadow(remap=false)
    public FilterItemStack.AttributeFilterItemStack.WhitelistMode whitelistMode;
    @Shadow(remap=false)
    public List<Pair<ItemAttribute, Boolean>> attributeTests;

    protected GenericAttributeFilterItemStackMixin(ItemStack filter) {
        super(filter);
    }

    @Overwrite(remap=false)
    public boolean test(Level world, FluidStack stack, boolean matchNBT) {
        if (this.attributeTests.isEmpty()) {
            return super.test(world, stack, matchNBT);
        }
        GenericStack genericStack = FluidGenericStack.wrap(stack);
        block13: for (Pair<ItemAttribute, Boolean> test : this.attributeTests) {
            boolean matches;
            ItemAttribute itemAttribute = (ItemAttribute)test.getFirst();
            boolean inverted = (Boolean)test.getSecond();
            if (!(itemAttribute instanceof GenericAttribute)) continue;
            GenericAttribute attribute = (GenericAttribute)itemAttribute;
            boolean bl = matches = attribute.appliesTo(genericStack, world) != inverted;
            if (matches) {
                switch (this.whitelistMode) {
                    case BLACKLIST: {
                        return false;
                    }
                    case WHITELIST_CONJ: {
                        continue block13;
                    }
                    case WHITELIST_DISJ: {
                        return true;
                    }
                }
                continue;
            }
            switch (this.whitelistMode) {
                case BLACKLIST: 
                case WHITELIST_DISJ: {
                    continue block13;
                }
                case WHITELIST_CONJ: {
                    return false;
                }
            }
        }
        return switch (this.whitelistMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterItemStack.AttributeFilterItemStack.WhitelistMode.BLACKLIST, FilterItemStack.AttributeFilterItemStack.WhitelistMode.WHITELIST_CONJ -> true;
            case FilterItemStack.AttributeFilterItemStack.WhitelistMode.WHITELIST_DISJ -> false;
        };
    }
}

