/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.ValueListDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.createmod.catnip.data.IntAttached;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBehaviour;

public class FactoryFluidGaugeDisplaySource
extends ValueListDisplaySource {
    protected Stream<IntAttached<MutableComponent>> provideEntries(DisplayLinkContext context, int maxRows) {
        List panels = context.blockEntity().factoryPanelSupport.getLinkedPanels();
        if (panels.isEmpty()) {
            return Stream.empty();
        }
        return panels.stream().map(fpp -> this.createEntry(context.level(), (FactoryPanelPosition)fpp)).filter(Objects::nonNull).limit(maxRows);
    }

    @Nullable
    public IntAttached<MutableComponent> createEntry(Level level, FactoryPanelPosition pos) {
        FactoryPanelBehaviour panel = FactoryPanelBehaviour.at((BlockAndTintGetter)level, (FactoryPanelPosition)pos);
        if (!(panel instanceof FactoryFluidPanelBehaviour)) {
            return null;
        }
        FactoryFluidPanelBehaviour fluidPanel = (FactoryFluidPanelBehaviour)panel;
        FluidStack fluid = fluidPanel.getFluid();
        GenericStack stack = GenericStack.of((FactoryPanelBehaviour)fluidPanel);
        int demand = stack.amount();
        String s = " ";
        if (demand != 0) {
            int promised = panel.getPromised();
            s = panel.satisfied ? "\u2714" : (promised != 0 ? "\u2191" : "\u25aa");
        }
        return IntAttached.with((int)panel.getLevelInStorage(), (Object)Component.m_237113_((String)(s + " ")).m_130938_(style -> style.m_178520_(panel.getIngredientStatusColor())).m_7220_((Component)fluid.getDisplayName().m_6879_().m_130940_(ChatFormatting.RESET)));
    }

    protected List<MutableComponent> createComponentsFromEntry(DisplayLinkContext context, IntAttached<MutableComponent> entry) {
        return List.of();
    }

    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
        Iterator it = this.provideEntries(context, stats.maxRows()).iterator();
        while (it.hasNext()) {
            IntAttached entry = (IntAttached)it.next();
            result.add((this.shortenNumbers(context) ? FactoryFluidPanelBehaviour.formatLevelShort((Integer)entry.getFirst()) : FactoryFluidPanelBehaviour.formatLevel((Integer)entry.getFirst())).space().add((MutableComponent)entry.getValue()).component());
        }
        return result;
    }

    public List<List<MutableComponent>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        ArrayList<List<MutableComponent>> result = new ArrayList<List<MutableComponent>>();
        Iterator it = this.provideEntries(context, stats.maxRows()).iterator();
        while (it.hasNext()) {
            IntAttached entry = (IntAttached)it.next();
            result.add(List.of((this.shortenNumbers(context) ? FactoryFluidPanelBehaviour.formatLevelShort((Integer)entry.getFirst()) : FactoryFluidPanelBehaviour.formatLevel((Integer)entry.getFirst())).space().add((MutableComponent)entry.getValue()).component()));
        }
        return result;
    }

    protected String getTranslationKey() {
        return "gauge_status";
    }

    protected boolean valueFirst() {
        return true;
    }
}

