/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeyClientGuiHandler;
import ru.zznty.create_factory_abstractions.render.SlotAmountRenderer;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBehaviour;
import ru.zznty.create_factory_logistics.render.FluidSlotRenderer;

public class FluidClientGuiHandler
implements GenericKeyClientGuiHandler<FluidKey> {
    public void renderDecorations(GuiGraphics graphics, FluidKey key, int amount, int x, int y) {
        SlotAmountRenderer.render((GuiGraphics)graphics, (float)x, (float)y, (String)FluidClientGuiHandler.formatValue(amount));
    }

    public void renderSlot(GuiGraphics graphics, FluidKey key, int x, int y) {
        FluidSlotRenderer.renderFluidSlot(graphics, x, y, key.stack());
    }

    public LangBuilder nameBuilder(FluidKey key, int amount) {
        return CreateLang.fluidName((FluidStack)key.stack()).space().add(FactoryFluidPanelBehaviour.formatLevel(amount));
    }

    public List<Component> tooltipBuilder(FluidKey key, int amount) {
        ArrayList<Component> list = new ArrayList<Component>(3);
        list.add(key.stack().getDisplayName());
        list.add((Component)Component.m_237119_());
        list.add((Component)FactoryFluidPanelBehaviour.formatLevel(amount, false).style(ChatFormatting.GRAY).component());
        return list;
    }

    public LangBuilder nameBuilder(FluidKey key) {
        return CreateLang.fluidName((FluidStack)key.stack());
    }

    public int stackSize(FluidKey key) {
        return 1000;
    }

    public int maxStackSize(FluidKey key) {
        return -1;
    }

    public static String formatValue(int count) {
        return FactoryFluidPanelBehaviour.formatLevelShort(count).string();
    }
}

