/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BookAuthorAttribute
implements ItemAttribute {
    private String author;

    public BookAuthorAttribute(String author) {
        this.author = author;
    }

    private static String extractAuthor(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("author")) {
            return nbt.m_128461_("author");
        }
        return "";
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        return BookAuthorAttribute.extractAuthor(itemStack).equals(this.author);
    }

    @Override
    public String getTranslationKey() {
        return "book_author";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.author};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.BOOK_AUTHOR;
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128359_("author", this.author);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.author = nbt.m_128461_("author");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new BookAuthorAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = BookAuthorAttribute.extractAuthor(stack);
            if (!name.isEmpty()) {
                list.add(new BookAuthorAttribute(name));
            }
            return list;
        }
    }
}

