/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.mixin.flw;

import com.mojang.blaze3d.vertex.BufferBuilder;
import dev.djefrey.colorwheel.engine.IrisTerrainVertexView;
import dev.engine_room.flywheel.api.vertex.VertexList;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import java.nio.ByteBuffer;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"dev.engine_room.flywheel.lib.model.baked.MeshHelper"})
public class MeshHelperMixin {
    @Inject(method={"blockVerticesToMesh"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectCustomVertexData(BufferBuilder.RenderedBuffer data, String meshDescriptor, CallbackInfoReturnable<SimpleQuadMesh> cir) {
        if (data.m_231198_().f_85733_() == IrisVertexFormats.TERRAIN) {
            BufferBuilder.DrawState drawState = data.m_231198_();
            int vertexCount = drawState.f_85734_();
            long srcStride = drawState.f_85733_().m_86020_();
            IrisTerrainVertexView vertexView = new IrisTerrainVertexView();
            long dstStride = vertexView.stride();
            ByteBuffer src = data.m_231196_();
            MemoryBlock dst = MemoryBlock.mallocTracked((long)((long)vertexCount * dstStride));
            long srcPtr = MemoryUtil.memAddress((ByteBuffer)src);
            long dstPtr = dst.ptr();
            MemoryUtil.memCopy((long)srcPtr, (long)dstPtr, (long)(srcStride * (long)vertexCount));
            vertexView.ptr(dstPtr);
            vertexView.vertexCount(vertexCount);
            vertexView.nativeMemoryOwner(dst);
            cir.setReturnValue((Object)new SimpleQuadMesh((VertexList)vertexView, meshDescriptor));
        }
    }
}

