/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.Heart;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;

public abstract class AppleSkinCommonCompat {
    public final Minecraft client = Minecraft.m_91087_();
    private final RandomSource random = RandomSource.m_216327_();
    protected int lastHealth;
    protected int lastModifiedHealth;
    private Heart[] hearts;

    public void drawHealthOverlay(GuiGraphics guiGraphics, int x, int y, int absorbing, int health, int modifiedHealth, float alpha, boolean hardcore) {
        long tickCount = this.client.f_91065_.m_93079_();
        this.random.m_188584_(tickCount * 312871L);
        if (this.lastHealth != health || this.lastModifiedHealth != modifiedHealth) {
            this.hearts = this.calculateHearts(health, modifiedHealth);
            this.lastHealth = health;
            this.lastModifiedHealth = modifiedHealth;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
        for (int index = 0; index < this.hearts.length; ++index) {
            Heart heart = this.hearts[index];
            int xPos = x + index % 10 * 8;
            int yPos = y - (index > 9 ? 10 : 0);
            if (health + absorbing <= 4) {
                yPos += this.random.m_188503_(2);
            }
            if (heart == null) continue;
            heart.draw(guiGraphics, xPos, yPos, hardcore, false, false);
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Heart[] calculateHearts(int health, int modifiedHealth) {
        List<HeartDrawing> healthDrawings = Hearts.COLORED_HEALTH_HEARTS;
        int healthDiff = modifiedHealth - health;
        int topHealth = modifiedHealth > 20 ? modifiedHealth % 20 : 0;
        int bottomIndex = Math.max(0, Mth.m_14107_((double)((double)modifiedHealth / 20.0)) - 1) % healthDrawings.size();
        HeartDrawing[] healthColors = new HeartDrawing[]{healthDrawings.get((bottomIndex + 1) % healthDrawings.size()), healthDrawings.get(bottomIndex)};
        int currentTopHealth = healthDiff >= 20 ? 0 : Math.max(0, health % 20);
        int bottomHealth = Math.min(20, healthDiff + currentTopHealth);
        --currentTopHealth;
        int modifiedHearts = Mth.m_14165_((double)((double)bottomHealth / 2.0));
        Heart[] hearts = new Heart[modifiedHearts];
        for (int i = 0; i < modifiedHearts; ++i) {
            boolean half;
            int value = i * 2;
            if (value < topHealth) {
                Heart background;
                half = value + 1 == topHealth;
                boolean includeBackground = value > currentTopHealth;
                Heart heart = background = includeBackground ? Heart.full(healthColors[1], false, Heart.CONTAINER_NONE) : Heart.CONTAINER_NONE;
                if (half) {
                    hearts[i] = Heart.full(healthColors[0], background);
                    continue;
                }
                hearts[i] = Heart.full(healthColors[0], false, background);
                continue;
            }
            if (value < currentTopHealth) {
                hearts[i] = null;
                continue;
            }
            if (value >= bottomHealth) continue;
            half = value + 1 == bottomHealth;
            hearts[i] = half ? Heart.full(healthColors[1], true, Heart.CONTAINER_NONE) : Heart.full(healthColors[1], false, Heart.CONTAINER_NONE);
        }
        return hearts;
    }
}

