/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.affix.IAffixLifecycle;
import top.theillusivec4.champions.common.affix.core.CombatAffix;

public class Utils {
    private static Boolean scalingHealthLoaded = null;
    private static Boolean gameStagesLoaded = null;
    private static Boolean gateways = null;
    private static Boolean oldForge = null;
    private static Boolean kubejs = null;

    public static boolean isOldForge() {
        if (oldForge == null) {
            try {
                ResourceLocation testUsage = ResourceLocation.fromNamespaceAndPath((String)"champions", (String)"for_test_usage");
                Champions.LOGGER.info("Use Newer forge ResourceLocation method {}", (Object)testUsage);
                oldForge = true;
                return oldForge;
            }
            catch (NoClassDefFoundError e) {
                ResourceLocation testUsage = new ResourceLocation("champions", "for_test_usage");
                oldForge = false;
                Champions.LOGGER.info("Use Old forge ResourceLocation method {}", (Object)testUsage);
            }
        }
        return oldForge;
    }

    public static boolean isGameStagesLoaded() {
        if (gameStagesLoaded == null) {
            gameStagesLoaded = ModList.get().isLoaded("gamestages");
        }
        return gameStagesLoaded;
    }

    public static boolean isGatewaysLoaded() {
        if (gateways == null) {
            gateways = ModList.get().isLoaded("gateways");
        }
        return gateways;
    }

    public static boolean isScalingHealthLoaded() {
        if (scalingHealthLoaded == null) {
            scalingHealthLoaded = ModList.get().isLoaded("scalinghealth");
        }
        return scalingHealthLoaded;
    }

    public static boolean isKubejsLoaded() {
        if (kubejs == null) {
            kubejs = ModList.get().isLoaded("kubejs");
        }
        return kubejs;
    }

    public static void createServerConfig(ForgeConfigSpec spec, String suffix) {
        String fileName = "champions-" + suffix + ".toml";
        Champions.getInstance().modContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec, fileName);
        File defaults = FMLPaths.GAMEDIR.get().resolve("defaultconfigs").resolve(fileName).toFile();
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(Champions.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                Champions.LOGGER.error("Error creating default config for {}", (Object)fileName);
            }
        }
    }

    public static ResourceLocation getLocation(String path) {
        return Utils.isOldForge() ? new ResourceLocation("champions", path) : ResourceLocation.fromNamespaceAndPath((String)"champions", (String)path);
    }

    public static Set<ResourceLocation> getLocationSet(String ... path) {
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (String s : path) {
            locations.add(Utils.getLocation(s));
        }
        return locations;
    }

    public static void consumeIfLifeCycle(List<IAffix> affixes, Consumer<IAffixLifecycle> consumer) {
        affixes.forEach(iAffix -> {
            if (iAffix instanceof IAffixLifecycle) {
                IAffixLifecycle lifecycle = (IAffixLifecycle)((Object)iAffix);
                consumer.accept(lifecycle);
            }
        });
    }

    public static void consumeIfCombat(List<IAffix> affixes, Consumer<CombatAffix> consumer) {
        affixes.forEach(iAffix -> {
            if (iAffix instanceof CombatAffix) {
                CombatAffix lifecycle = (CombatAffix)iAffix;
                consumer.accept(lifecycle);
            }
        });
    }
}

