/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.affix.IAffixBase;
import top.theillusivec4.champions.api.data.ChampionModifierCondition;
import top.theillusivec4.champions.api.data.IntCodec;

public record AffixesPredicate(Set<ResourceLocation> values, MinMaxBounds.Ints matches, MinMaxBounds.Ints count) {
    public static Codec<AffixesPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChampionModifierCondition.setOf(ResourceLocation.f_135803_).fieldOf("values").forGetter(AffixesPredicate::values), (App)IntCodec.codec().fieldOf("matches").forGetter(AffixesPredicate::matches), (App)IntCodec.codec().fieldOf("count").forGetter(AffixesPredicate::count)).apply((Applicative)instance, AffixesPredicate::new));

    public static AffixesPredicate fromJson(JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonArray()) {
                JsonArray jsonArray = GsonHelper.m_13924_((JsonElement)json, (String)"affixes");
                HashSet<ResourceLocation> affixes = new HashSet<ResourceLocation>();
                for (JsonElement jsonElement : jsonArray) {
                    if (!jsonElement.isJsonPrimitive()) continue;
                    affixes.add(ResourceLocation.m_135820_((String)jsonElement.getAsString()));
                }
                return new AffixesPredicate(affixes, MinMaxBounds.Ints.m_55386_((int)1), MinMaxBounds.Ints.f_55364_);
            }
            JsonObject jsonObject = json.getAsJsonObject();
            HashSet<ResourceLocation> affixes = new HashSet<ResourceLocation>();
            if (jsonObject.has("values")) {
                JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"values");
                for (JsonElement jsonElement : jsonArray) {
                    if (!jsonElement.isJsonPrimitive()) continue;
                    affixes.add(ResourceLocation.m_135820_((String)jsonElement.getAsString()));
                }
            }
            MinMaxBounds.Ints matches = MinMaxBounds.Ints.m_55386_((int)1);
            if (jsonObject.has("matches")) {
                matches = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("matches"));
            }
            MinMaxBounds.Ints count = MinMaxBounds.Ints.f_55364_;
            if (jsonObject.has("count")) {
                count = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("count"));
            }
            return new AffixesPredicate(affixes, matches, count);
        }
        return AffixesPredicate.getAny();
    }

    public static Codec<AffixesPredicate> codec() {
        if (CODEC == null) {
            CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChampionModifierCondition.setOf(ResourceLocation.f_135803_).fieldOf("values").forGetter(AffixesPredicate::values), (App)IntCodec.codec().fieldOf("matches").forGetter(AffixesPredicate::matches), (App)IntCodec.codec().fieldOf("count").forGetter(AffixesPredicate::count)).apply((Applicative)instance, AffixesPredicate::new));
        }
        return CODEC;
    }

    public static AffixesPredicate getAny() {
        return new AffixesPredicate(new HashSet<ResourceLocation>(), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_);
    }

    public boolean matches(List<IAffix> input) {
        if (this.values.isEmpty()) {
            return this.count.m_55390_(input.size());
        }
        Set affixes = input.stream().map(IAffixBase::getIdentifier).collect(Collectors.toSet());
        int found = 0;
        for (ResourceLocation affix : this.values) {
            if (!affixes.contains(affix)) continue;
            ++found;
        }
        return this.matches.m_55390_(found) && this.count.m_55390_(input.size());
    }

    public JsonElement serializeToJson() {
        if (this.values.isEmpty() && this.count.m_55327_() && this.matches.m_55327_()) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (ResourceLocation value : this.values) {
            jsonArray.add(value.toString());
        }
        Integer min = (Integer)this.count.m_55305_();
        Integer max = (Integer)this.count.m_55326_();
        if (min != null && min == 1 && max == null) {
            return jsonArray;
        }
        jsonObject.add("values", (JsonElement)jsonArray);
        jsonObject.add("matches", this.matches.m_55328_());
        jsonObject.add("count", this.count.m_55328_());
        return jsonObject;
    }
}

