/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.common.entity.animal;

import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearAttackPlayerGoal;
import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearHurtByTargetGoal;
import com.teamabnormals.buzzier_bees.common.entity.ai.goal.BearPanicGoal;
import com.teamabnormals.buzzier_bees.core.other.tags.BBItemTags;
import com.teamabnormals.buzzier_bees.core.registry.BBEntityTypes;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class GrizzlyBear
extends Animal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(GrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HONEY = SynchedEntityData.m_135353_(GrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_();
    public int eatTicks;

    public GrizzlyBear(EntityType<? extends GrizzlyBear> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new GrizzlyBearLookControl();
        this.f_21342_ = new GrizzlyMoveControl();
        this.m_21553_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BearPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SeekShelterGoal(1.25));
        this.f_21345_.m_25352_(3, (Goal)new GrizzlyMeleeAttackGoal(1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new BearHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, new BearAttackPlayerGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, true, living -> living instanceof Player || living instanceof Monster));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, 10, true, true, null));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(BBItemTags.GRIZZLY_BEAR_FOOD);
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundEvents.f_12281_ : SoundEvents.f_12280_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HONEY, (Object)false);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Honey", this.isHoney());
        tag.m_128379_("Sleeping", this.m_5803_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHoney(tag.m_128471_("Honey"));
        this.setSleeping(tag.m_128471_("Sleeping"));
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)BBEntityTypes.GRIZZLY_BEAR.get()).m_20615_((Level)world);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isHoney() && stack.m_150930_(Items.f_42590_)) {
            stack.m_41774_(1);
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42787_));
            } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42787_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_42787_), false);
            }
            this.m_9236_().m_220400_((Entity)player, GameEvent.f_157816_, this.m_20182_());
        }
        return super.m_6071_(player, hand);
    }

    private boolean canEatItem(ItemStack stack) {
        return stack.m_41614_() && this.m_5448_() == null && this.m_20096_();
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack heldItem = this.m_6844_(EquipmentSlot.MAINHAND);
        return heldItem.m_41619_() || this.eatTicks > 0 && item.m_41472_() && !heldItem.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack stack) {
        if (!stack.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stack);
            entity.m_32010_(40);
            entity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)entity);
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)entity);
    }

    protected void m_7581_(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        if (this.m_7252_(stack)) {
            int i = stack.m_41613_();
            if (i > 1) {
                this.spawnItem(stack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(entity);
            this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)entity, stack.m_41613_());
            entity.m_146870_();
            this.eatTicks = 0;
        }
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            ++this.eatTicks;
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEatItem(stack)) {
                if (this.eatTicks > 600) {
                    ItemStack returnStack = stack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!returnStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, returnStack);
                    }
                    this.eatTicks = 0;
                } else if (this.eatTicks > 500 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
        }
        super.m_8107_();
    }

    public boolean isHoney() {
        return (Boolean)this.f_19804_.m_135370_(HONEY);
    }

    public void setHoney(boolean honey) {
        this.f_19804_.m_135381_(HONEY, (Object)honey);
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    public void setSleeping(boolean sleeping) {
        this.setFlag(32, sleeping);
    }

    private void setFlag(int flag, boolean value) {
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | flag)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~flag)));
        }
    }

    private boolean getFlag(int p_28609_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_28609_) != 0;
    }

    public void clearStates() {
        this.setSleeping(false);
    }

    public void m_8119_() {
        boolean flag;
        super.m_8119_();
        if (this.m_21515_() && ((flag = this.m_20069_()) || this.m_5448_() != null || this.m_9236_().m_46470_())) {
            this.setSleeping(false);
        }
    }

    public boolean m_7327_(Entity target) {
        boolean flag = target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
        }
        return flag;
    }

    boolean canMove() {
        return !this.m_5803_();
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnData, tag);
    }

    public class GrizzlyBearLookControl
    extends LookControl {
        public GrizzlyBearLookControl() {
            super((Mob)GrizzlyBear.this);
        }

        public void m_8128_() {
            if (!GrizzlyBear.this.m_5803_()) {
                super.m_8128_();
            }
        }
    }

    class GrizzlyMoveControl
    extends MoveControl {
        public GrizzlyMoveControl() {
            super((Mob)GrizzlyBear.this);
        }

        public void m_8126_() {
            if (GrizzlyBear.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double p_28777_) {
            super((PathfinderMob)GrizzlyBear.this, p_28777_);
            this.interval = SeekShelterGoal.m_186073_((int)100);
        }

        public boolean m_8036_() {
            if (!GrizzlyBear.this.m_5803_() && this.f_25214_.m_5448_() == null) {
                if (GrizzlyBear.this.m_9236_().m_46470_() && GrizzlyBear.this.m_9236_().m_45527_(this.f_25214_.m_20183_())) {
                    return this.m_25226_();
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.f_25214_.m_20183_();
                return GrizzlyBear.this.m_9236_().m_46461_() && GrizzlyBear.this.m_9236_().m_45527_(blockpos) && !((ServerLevel)GrizzlyBear.this.m_9236_()).m_8802_(blockpos) && this.m_25226_();
            }
            return false;
        }

        public void m_8056_() {
            GrizzlyBear.this.clearStates();
            super.m_8056_();
        }
    }

    class GrizzlyMeleeAttackGoal
    extends MeleeAttackGoal {
        public GrizzlyMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super((PathfinderMob)GrizzlyBear.this, p_28720_, p_28721_);
        }

        public boolean m_8036_() {
            return !GrizzlyBear.this.m_5803_() && super.m_8036_();
        }
    }

    class SleepGoal
    extends GrizzlyBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = GrizzlyBear.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (GrizzlyBear.this.f_20900_ == 0.0f && GrizzlyBear.this.f_20901_ == 0.0f && GrizzlyBear.this.f_20902_ == 0.0f) {
                return this.canSleep() || GrizzlyBear.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return GrizzlyBear.this.m_9236_().m_46461_() && this.hasShelter() && !this.alertable() && !GrizzlyBear.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = GrizzlyBear.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            GrizzlyBear.this.clearStates();
        }

        public void m_8056_() {
            GrizzlyBear.this.m_6862_(false);
            GrizzlyBear.this.setSleeping(true);
            GrizzlyBear.this.m_21573_().m_26573_();
            GrizzlyBear.this.m_21566_().m_6849_(GrizzlyBear.this.m_20185_(), GrizzlyBear.this.m_20186_(), GrizzlyBear.this.m_20189_(), 0.0);
        }
    }

    class GrizzlyLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public GrizzlyLookAtPlayerGoal(Mob p_25520_, Class<? extends LivingEntity> p_25521_, float p_25522_) {
            super(p_25520_, p_25521_, p_25522_);
        }

        public boolean m_8045_() {
            if (!GrizzlyBear.this.canMove()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public static class GrizzlyBearAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity entity) {
            if (entity instanceof GrizzlyBear) {
                return false;
            }
            if (!(entity instanceof Chicken) && !(entity instanceof Rabbit)) {
                if (entity instanceof TamableAnimal) {
                    return !((TamableAnimal)entity).m_21824_();
                }
                if (!(entity instanceof Player) || !entity.m_5833_() && !((Player)entity).m_7500_()) {
                    return !entity.m_5803_() && !entity.m_20163_();
                }
                return false;
            }
            return true;
        }
    }

    abstract class GrizzlyBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting = TargetingConditions.m_148352_().m_26883_(16.0).m_148355_().m_26888_((Predicate)new GrizzlyBearAlertableEntitiesSelector());

        GrizzlyBehaviorGoal() {
        }

        protected boolean hasShelter() {
            BlockPos blockpos = BlockPos.m_274561_((double)GrizzlyBear.this.m_20185_(), (double)GrizzlyBear.this.m_20191_().f_82292_, (double)GrizzlyBear.this.m_20189_());
            return !GrizzlyBear.this.m_9236_().m_45527_(blockpos) && GrizzlyBear.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !GrizzlyBear.this.m_9236_().m_45971_(LivingEntity.class, this.alertableTargeting, (LivingEntity)GrizzlyBear.this, GrizzlyBear.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

