/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.network.particle;

import com.teamabnormals.blueprint.client.ClientInfo;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class MessageS2CSpawnParticle {
    public String particleName;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;

    public MessageS2CSpawnParticle(String particleName, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        this.particleName = particleName;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130070_(this.particleName);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
    }

    public static MessageS2CSpawnParticle deserialize(FriendlyByteBuf buf) {
        String particleName = buf.m_130277_();
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double motionX = buf.readDouble();
        double motionY = buf.readDouble();
        double motionZ = buf.readDouble();
        return new MessageS2CSpawnParticle(particleName, posX, posY, posZ, motionX, motionY, motionZ);
    }

    public static void handle(MessageS2CSpawnParticle message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Level level = ClientInfo.getClientPlayerLevel();
                SimpleParticleType particleType = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(message.particleName));
                if (particleType != null) {
                    level.m_7106_((ParticleOptions)particleType, message.posX, message.posY, message.posZ, message.motionX, message.motionY, message.motionZ);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

