/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.builtin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.builtin.AtmosphericProcessorLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.apache.commons.compress.utils.Lists;

public class AtmosphericTemplatePools {
    public static final ResourceKey<StructureTemplatePool> PETRIFIED_GARDEN = AtmosphericTemplatePools.createKey("arid_garden/petrified_garden");

    public static void bootstrap(BootstapContext<StructureTemplatePool> context) {
        HolderGetter processorLists = context.m_255420_(Registries.f_257011_);
        Holder.Reference petrifiedAridGarden = processorLists.m_255043_(AtmosphericProcessorLists.PETRIFIED_ARID_GARDEN);
        HolderGetter templatePools = context.m_255420_(Registries.f_256948_);
        Holder.Reference empty = templatePools.m_255043_(Pools.f_127186_);
        context.m_255272_(PETRIFIED_GARDEN, (Object)AtmosphericTemplatePools.structureTemplatePool((Holder<StructureTemplatePool>)empty, "arid_garden/petrified_garden/petrified_garden", 6, (Holder<StructureProcessorList>)petrifiedAridGarden));
    }

    public static StructureTemplatePool structureTemplatePool(Holder<StructureTemplatePool> fallback, String name, int count, Holder<StructureProcessorList> processor) {
        ArrayList elements = Lists.newArrayList();
        for (int i = 1; i <= count; ++i) {
            elements.add(AtmosphericTemplatePools.singlePoolElement(name + "_" + i, processor));
        }
        return new StructureTemplatePool(fallback, (List)ImmutableList.copyOf((Collection)elements), StructureTemplatePool.Projection.RIGID);
    }

    public static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> singlePoolElement(String name, Holder<StructureProcessorList> holderGetter) {
        return Pair.of((Object)StructurePoolElement.m_210531_((String)Atmospheric.location(name).toString(), holderGetter), (Object)1);
    }

    public static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }
}

