/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class GrimwoodTreeFeature
extends BlueprintTreeFeature {
    public GrimwoodTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < trunkHeight; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.addLog(origin.m_7918_(i, j, k));
                }
            }
        }
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        boolean positive = direction.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean xAxis = direction.m_122434_() == Direction.Axis.X;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)origin.m_7918_(xAxis ? (positive ? 1 : 0) : random.m_188503_(2), trunkHeight, !xAxis ? (positive ? 1 : 0) : random.m_188503_(2)));
        this.addLog((BlockPos)pos);
        this.createBranch(2 + random.m_188503_(2), 3 + random.m_188503_(2), pos, direction, random, config);
        if (random.m_188503_(3) != 0) {
            this.createBranch(2 + random.m_188503_(3), 3 + random.m_188503_(2), pos, direction.m_122424_(), random, config);
            this.createBranch(1 + random.m_188503_(2), 2 + random.m_188503_(2), pos, direction, random, config);
        }
        int height = 5 + random.m_188503_(5) + random.m_188503_(3);
        this.createBranch(1 + random.m_188503_(3), height, pos, direction.m_122424_(), random, config);
        this.addFoliage(pos.m_7494_());
        this.createLeafLayer((BlockPos)pos, 1, true);
        boolean big = false;
        for (int i = 0; i < height - 2 - random.m_188503_(2); ++i) {
            if (!big) {
                boolean bl = big = i > 3 && random.m_188499_();
            }
            if (i % 2 != 0) continue;
            this.createLeafLayer((BlockPos)pos.m_122190_((Vec3i)pos.m_6625_(2)), big ? 3 : 2, false);
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.GRIMWOOD_SAPLING.get()).m_49966_();
    }

    private void createBranch(int depth, int height, BlockPos.MutableBlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        int j;
        for (j = 0; j < depth; ++j) {
            this.addSpecialLog((BlockPos)pos.m_122190_((Vec3i)pos.m_121945_(direction)), (BlockState)config.f_68185_.m_213972_(random, (BlockPos)pos).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)direction.m_122434_()));
        }
        for (j = 0; j < height; ++j) {
            this.addLog((BlockPos)pos.m_122190_((Vec3i)pos.m_7494_()));
        }
    }

    private void createLeafLayer(BlockPos pos, int leafSize, boolean square) {
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                if (square) {
                    this.addFoliage(pos.m_7918_(i, 0, k));
                    continue;
                }
                int xDis = Math.abs(i);
                int zDis = Math.abs(k);
                if (xDis == leafSize && zDis == leafSize || leafSize > 2 && (xDis == leafSize && zDis == leafSize - 1 || xDis == leafSize - 1 && zDis == leafSize)) continue;
                this.addFoliage(pos.m_7918_(i, 0, k));
            }
        }
    }
}

