/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.datagen;

import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class AALanguageProvider
extends LanguageProvider {
    public static final String PREFIX = "attribute.additional_attributes.";
    private static final List<String> SKIP = List.of("fishing_lure", "fishing_luck", "looting", "respiration", "harvest", "keep_scroll", "spell_general");

    public AALanguageProvider(PackOutput output, String locale) {
        super(output, "additional_attributes", locale);
    }

    protected void addTranslations() {
        this.add("ui.additional_attributes.cast_error_no_spell_level", "You do not possess the knowledge required to cast this spell");
        this.add("attribute.additional_attributes.fishing_lure", "Fishing Lure");
        this.add("attribute.additional_attributes.fishing_lure.desc", "Modifies the fishing lure level of the player");
        this.add("attribute.additional_attributes.fishing_luck", "Fishing Luck");
        this.add("attribute.additional_attributes.fishing_luck.desc", "Modifies the fishing luck level of the player");
        this.add("attribute.additional_attributes.looting", "Looting");
        this.add("attribute.additional_attributes.looting.desc", "Modifies the looting level of the player");
        this.add("attribute.additional_attributes.respiration", "Respiration");
        this.add("attribute.additional_attributes.respiration.desc", "Modifies the respiration level of the player");
        this.add("attribute.additional_attributes.harvest", "Harvesting");
        this.add("attribute.additional_attributes.harvest.desc", "Modifies the amount of harvested crops");
        this.add("attribute.additional_attributes.apothic_crafting", "Apothic Crafting");
        this.add("attribute.additional_attributes.apothic_crafting.desc", "Grants the chance to craft affixed items (min. affix rarity will increase in increments of 1)");
        this.add("attribute.additional_attributes.keep_scroll", "Keep Scroll");
        this.add("attribute.additional_attributes.keep_scroll.desc", "Chance to not use up a spell scroll");
        this.add("attribute.additional_attributes.spell_general", "General Spell Level");
        this.add("attribute.additional_attributes.spell_general.desc", "Modifies the level of all spells");
        ForgeRegistries.ATTRIBUTES.getEntries().forEach(attribute -> {
            ResourceLocation location = ((ResourceKey)attribute.getKey()).m_135782_();
            if (!location.m_135827_().equals("additional_attributes") || SKIP.contains(location.m_135815_())) {
                return;
            }
            String path = location.m_135815_();
            StringBuilder readable = new StringBuilder();
            if (this.handleInnateAttribute(location)) {
                return;
            }
            String[] split = path.split("_");
            for (int i = 2; i < split.length; ++i) {
                readable.append(Character.toUpperCase(split[i].charAt(0)));
                readable.append(split[i].substring(1));
                if (i != split.length - 1) {
                    readable.append(" ");
                    continue;
                }
                if (path.startsWith("spell_school_")) {
                    this.add("attribute." + location.m_214298_(), readable.append(" School Level").toString());
                    this.add("attribute." + location.m_214298_() + ".desc", "Modifies the level of all spells of this school");
                    continue;
                }
                if (!path.startsWith("spell_type_")) continue;
                this.add("attribute." + location.m_214298_(), readable.append(" Spell Level").toString());
                this.add("attribute." + location.m_214298_() + ".desc", "Modifies the level of this spell");
            }
        });
    }

    private boolean handleInnateAttribute(ResourceLocation location) {
        boolean isSchool = location.m_135815_().startsWith("innate_school/");
        boolean isSpell = location.m_135815_().startsWith("innate_spell/");
        if (!isSchool && !isSpell) {
            return false;
        }
        String[] elements = location.toString().split("/");
        String[] nameParts = elements[2].split("_");
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < nameParts.length; ++i) {
            String namePart = nameParts[i];
            name.append(Character.toUpperCase(namePart.charAt(0))).append(namePart.substring(1));
            if (i == nameParts.length - 1) continue;
            name.append(" ");
        }
        if (isSchool) {
            this.add("attribute." + location.m_214298_(), "Innate School: " + name);
            this.add("attribute." + location.m_214298_() + ".desc", "Grants all spells of this school (level is based on attribute value)");
        } else {
            this.add("attribute." + location.m_214298_(), "Innate Spell: " + name);
            this.add("attribute." + location.m_214298_() + ".desc", "Grants this spell (level is based on attribute value)");
        }
        return true;
    }
}

