/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.registry;

import com.ninni.twigs.TwigsTags;
import com.ninni.twigs.registry.TwigsPlacedFeatures;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TwigsBiomeModifier {
    private static final ResourceKey<BiomeModifier> ADD_ORE_BLOODSTONE = TwigsBiomeModifier.createKey("add_ore_bloodstone");
    private static final ResourceKey<BiomeModifier> ORE_RHYOLITE = TwigsBiomeModifier.createKey("add_ore_rhyolite");
    private static final ResourceKey<BiomeModifier> ADD_ORE_SCHIST = TwigsBiomeModifier.createKey("add_ore_schist");
    private static final ResourceKey<BiomeModifier> ADD_SILT_STRIP = TwigsBiomeModifier.createKey("add_silt_strip");
    private static final ResourceKey<BiomeModifier> ADD_AZALEA_FLOWERS = TwigsBiomeModifier.createKey("add_azalea_flowers");
    private static final ResourceKey<BiomeModifier> ADD_TWIGS = TwigsBiomeModifier.createKey("add_twigs");
    private static final ResourceKey<BiomeModifier> ADD_PEBBLES = TwigsBiomeModifier.createKey("add_pebbles");
    private static final ResourceKey<BiomeModifier> ADD_LAND_SEA_SHELLS = TwigsBiomeModifier.createKey("add_land_sea_shells");
    private static final ResourceKey<BiomeModifier> ADD_WATER_SEA_SHELLS = TwigsBiomeModifier.createKey("add_water_sea_shells");

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        context.m_255272_(ADD_ORE_BLOODSTONE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.BLOODSTONE_GENERATES), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.ORE_BLOODSTONE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(ORE_RHYOLITE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, (TagKey<Biome>)BiomeTags.f_215817_), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.ORE_RHYOLITE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(ADD_ORE_SCHIST, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.SCHIST_GENERATES), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.ORE_SCHIST_LOWER, TwigsPlacedFeatures.ORE_SCHIST_UPPER), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(ADD_SILT_STRIP, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, (TagKey<Biome>)BiomeTags.f_207612_), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.SILT_STRIP), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(ADD_AZALEA_FLOWERS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.AZALEA_FLOWERS_GENERATE), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.AZALEA_FLOWERS), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_TWIGS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.SPAWNS_TWIG), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.PATCH_TWIG), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_PEBBLES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.SPAWNS_PEBBLE), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.PATCH_PEBBLE), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_LAND_SEA_SHELLS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.SPAWNS_SEA_SHELL), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.PATCH_SEASHELL_LAND), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_WATER_SEA_SHELLS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(TwigsBiomeModifier.biomeTag(context, TwigsTags.SPAWNS_SEA_SHELL), TwigsBiomeModifier.getPlacedFeature(context, TwigsPlacedFeatures.PATCH_SEASHELL_WATER), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> ... placedFeature) {
        return HolderSet.m_205800_(Stream.of(placedFeature).map(resourceKey -> context.m_255420_(Registries.f_256988_).m_255043_(resourceKey)).collect(Collectors.toList()));
    }

    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeature) {
        return HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(placedFeature)});
    }

    @NotNull
    private static HolderSet.Named<Biome> biomeTag(BootstapContext<BiomeModifier> context, TagKey<Biome> tag) {
        return context.m_255420_(Registries.f_256952_).m_254956_(tag);
    }

    public static ResourceKey<BiomeModifier> createKey(String string) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("twigs", string));
    }
}

