/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.salju.trialstowers.entity.Breeze;

public class BreezeWindModel<T extends Breeze>
extends EntityModel<T> {
    private final ModelPart top;
    private final ModelPart middle;
    private final ModelPart bottom;

    public BreezeWindModel(ModelPart root) {
        this.top = root.m_171324_("top");
        this.middle = root.m_171324_("middle");
        this.bottom = root.m_171324_("bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition top = partdefinition.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -4.0f, -9.0f, 18.0f, 8.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(6, 6).m_171488_(-6.0f, -4.0f, -6.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(105, 57).m_171488_(-2.5f, -4.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition middle = partdefinition.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(74, 28).m_171488_(-6.0f, -3.0f, -6.0f, 12.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(78, 32).m_171488_(-4.0f, -3.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(49, 71).m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition bottom = partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(1, 83).m_171488_(-2.5f, -3.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Breeze brezo, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        int e = 360;
        float f = ((float)Math.floorMod(brezo.m_9236_().m_46467_(), (long)e) + ageInTicks) / (float)e;
        this.top.f_104204_ = (float)((double)f * Math.PI * 25.0);
        this.middle.f_104204_ = (float)((double)f * Math.PI * 25.0);
        this.bottom.f_104204_ = (float)((double)f * Math.PI * 25.0);
        float fml = ageInTicks * (float)Math.PI * -0.07f;
        this.top.f_104200_ = Mth.m_14089_((float)fml) * 1.0f;
        this.top.f_104202_ = Mth.m_14031_((float)fml) * 1.0f;
        this.middle.f_104200_ = Mth.m_14089_((float)fml) * 1.0f;
        this.middle.f_104202_ = Mth.m_14031_((float)fml) * 1.0f;
        this.bottom.f_104200_ = Mth.m_14089_((float)fml) * 1.0f;
        this.bottom.f_104202_ = Mth.m_14031_((float)fml) * 1.0f;
    }

    public void m_7695_(PoseStack pose, VertexConsumer v, int l, int o, float red, float green, float blue, float alpha) {
        this.top.m_104306_(pose, v, l, o, red, green, blue, alpha);
        this.middle.m_104306_(pose, v, l, o, red, green, blue, alpha);
        this.bottom.m_104306_(pose, v, l, o, red, green, blue, alpha);
    }
}

