/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.salju.trialstowers.gui.CrafterGuiMenu;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsTags;

public class CrafterEntity
extends BaseContainerBlockEntity
implements CraftingContainer {
    public NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);

    public CrafterEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TrialsBlockEntities.CRAFTER.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.stacks);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection queen, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)packet.m_131708_(), this.stacks);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
        return tag;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.trials.crafter");
    }

    public AbstractContainerMenu m_6555_(int i, Inventory bag) {
        return new CrafterGuiMenu(i, bag, (Container)this);
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public int m_39347_() {
        return 3;
    }

    public int m_39346_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.getResultItem().m_41619_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public ItemStack m_8020_(int i) {
        if (this.isResultItem((ItemStack)this.stacks.get(i))) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.stacks.get(i);
    }

    public boolean m_7013_(int i, ItemStack stack) {
        int c = 64;
        for (int e = 0; e < 9; ++e) {
            if (this.m_8020_(e).m_41619_() && !this.isLocked()) {
                i = e;
                break;
            }
            if (this.m_8020_(e).m_41720_() != stack.m_41720_() || this.m_8020_(e).m_41613_() == this.m_8020_(e).m_41741_()) continue;
            if (this.m_8020_(e).m_41613_() <= 1) {
                i = e;
                break;
            }
            if (this.m_8020_(e).m_41613_() >= c) continue;
            i = e;
            c = this.m_8020_(e).m_41613_();
        }
        if (this.m_8020_(i).m_41619_() && !this.isLocked()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.m_6836_(i, copy);
            stack.m_41774_(1);
        } else if (this.m_8020_(i).m_41720_() == stack.m_41720_() && this.m_8020_(i).m_41613_() < this.m_8020_(i).m_41741_()) {
            this.m_8020_(i).m_41764_(this.m_8020_(i).m_41613_() + 1);
            stack.m_41774_(1);
        }
        return false;
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.stacks, (int)i);
    }

    public ItemStack m_7407_(int i, int e) {
        this.updateBlock();
        return ContainerHelper.m_18969_(this.stacks, (int)i, (int)e);
    }

    public void m_6836_(int i, ItemStack stack) {
        this.stacks.set(i, (Object)stack.m_41777_());
        this.updateBlock();
    }

    public void m_6211_() {
        double x = this.m_58899_().m_123341_();
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = this.m_58899_().m_123343_();
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_() || this.isResultItem(stack)) continue;
            Containers.m_18992_((Level)this.m_58904_(), (double)x, (double)y, (double)z, (ItemStack)stack);
        }
        this.updateBlock();
    }

    public List<ItemStack> m_280657_() {
        return List.copyOf(this.stacks);
    }

    public void m_5809_(StackedContents conts) {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_() || this.isResultItem(stack)) continue;
            conts.m_36466_(stack);
        }
    }

    public ItemStack getResultItem() {
        return (ItemStack)this.stacks.get(9);
    }

    public void setResultItem(ItemStack stack) {
        this.stacks.set(9, (Object)stack.m_41777_());
        this.updateBlock();
    }

    public int getPower() {
        int i = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_() || this.isResultItem(stack)) continue;
            ++i;
        }
        return i;
    }

    public boolean isResultItem(ItemStack stack) {
        return stack == this.getResultItem();
    }

    public boolean canCraftItem() {
        if (this.isLocked()) {
            for (ItemStack stack : this.stacks) {
                if (stack.m_41613_() != 1 || this.isResultItem(stack)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLocked() {
        return this.m_58904_().m_8055_(this.m_58899_().m_7495_()).m_204336_(TrialsTags.LOCKED);
    }

    public void craftItem(Direction dir) {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        if (dir == Direction.EAST) {
            x += 0.65;
        } else if (dir == Direction.WEST) {
            x -= 0.65;
        } else if (dir == Direction.NORTH) {
            z -= 0.65;
        } else if (dir == Direction.SOUTH) {
            z += 0.65;
        }
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            lvl.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 6, 0.12, 0.12, 0.12, 0.0);
        }
        Containers.m_18992_((Level)this.m_58904_(), (double)x, (double)y, (double)z, (ItemStack)this.getResultItem());
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_() || this.isResultItem(stack)) continue;
            if (stack.hasCraftingRemainingItem()) {
                Containers.m_18992_((Level)this.m_58904_(), (double)x, (double)y, (double)z, (ItemStack)stack.getCraftingRemainingItem());
            }
            stack.m_41774_(1);
        }
    }

    public void updateBlock() {
        this.m_6596_();
        this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CrafterEntity target) {
        if (world instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)world;
            Optional optional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)target, world);
            if (optional.isPresent()) {
                ItemStack crafted = ((CraftingRecipe)optional.get()).m_5874_((Container)target, world.m_9598_());
                if (crafted.m_246617_(world.m_246046_())) {
                    target.setResultItem(crafted);
                }
            } else {
                target.setResultItem(ItemStack.f_41583_);
            }
        }
    }
}

