/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.tile;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.init.TranslocatorsModContent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class TileCraftingGrid
extends BlockEntity {
    public ItemStack[] items = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[9], (Object)ItemStack.f_41583_);
    public ItemStack result = ItemStack.f_41583_;
    public int rotation = 0;
    public int timeout = 400;

    public TileCraftingGrid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TranslocatorsModContent.tileCraftingGridType.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("items", (Tag)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        tag.m_128405_("timeout", this.timeout);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (ListTag)tag.m_128437_("items", 10));
        this.timeout = tag.m_128451_("timeout");
    }

    public void tickServer() {
        --this.timeout;
        if (this.timeout == 0) {
            this.dropItems();
            this.f_58857_.m_7471_(this.m_58899_(), false);
        }
    }

    public void dropItems() {
        Vector3 drop = Vector3.fromTileCenter((BlockEntity)this);
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            ItemUtils.dropItem((ItemStack)item, (Level)this.f_58857_, (Vector3)drop);
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, e -> {
            MCDataByteBuf packet = new MCDataByteBuf();
            this.writeToPacket((MCDataOutput)packet);
            CompoundTag tag = new CompoundTag();
            packet.writeToNBT(tag, "data");
            return tag;
        });
    }

    public CompoundTag m_5995_() {
        MCDataByteBuf packet = new MCDataByteBuf();
        this.writeToPacket((MCDataOutput)packet);
        return packet.writeToNBT(super.m_5995_(), "data");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readFromPacket((MCDataInput)MCDataByteBuf.readFromNBT((CompoundTag)pkt.m_131708_(), (String)"data"));
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readFromPacket((MCDataInput)MCDataByteBuf.readFromNBT((CompoundTag)tag, (String)"data"));
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeByte(this.rotation);
        for (ItemStack item : this.items) {
            packet.writeItemStack(item);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.rotation = packet.readUByte();
        for (int i = 0; i < 9; ++i) {
            this.items[i] = packet.readItemStack();
        }
        this.updateResult();
    }

    public void activate(int subHit, Player player) {
        ItemStack held = player.m_150109_().m_36056_();
        if (held.m_41619_()) {
            if (!this.items[subHit].m_41619_()) {
                this.giveOrDropItem(this.items[subHit], player);
            }
            this.items[subHit] = ItemStack.f_41583_;
        } else if (!InventoryUtils.areStacksIdentical((ItemStack)held, (ItemStack)this.items[subHit])) {
            ItemStack old = this.items[subHit];
            this.items[subHit] = ItemUtils.copyStack((ItemStack)held, (int)1);
            player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
            if (!old.m_41619_()) {
                this.giveOrDropItem(old, player);
            }
        }
        this.timeout = 2400;
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        this.m_6596_();
    }

    private void updateResult() {
        CraftingContainer craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            Optional mresult = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftMatrix, this.f_58857_);
            if (mresult.isPresent()) {
                this.result = ((CraftingRecipe)mresult.get()).m_5874_((Container)craftMatrix, this.f_58857_.m_9598_());
                return;
            }
            this.rotateItems(craftMatrix);
        }
        this.result = ItemStack.f_41583_;
    }

    private void giveOrDropItem(ItemStack stack, Player player) {
        if (player.m_150109_().m_36054_(stack)) {
            player.f_36095_.m_38946_();
        } else {
            ItemUtils.dropItem((ItemStack)stack, (Level)this.f_58857_, (Vector3)Vector3.fromTileCenter((BlockEntity)this));
        }
    }

    public void craft(ServerPlayer player) {
        CraftingContainer craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            CraftingRecipe recipe;
            Optional mresult = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftMatrix, this.f_58857_);
            if (mresult.isPresent() && ((recipe = (CraftingRecipe)mresult.get()).m_5598_() || !this.f_58857_.m_46469_().m_46207_(GameRules.f_46151_) || player.m_8952_().m_12709_((Recipe)recipe))) {
                this.doCraft(recipe, recipe.m_5874_((Container)craftMatrix, this.f_58857_.m_9598_()), craftMatrix, (Player)player);
                break;
            }
            this.rotateItems(craftMatrix);
        }
        player.m_6674_(InteractionHand.MAIN_HAND);
        this.dropItems();
        this.f_58857_.m_7471_(this.m_58899_(), false);
    }

    private CraftingContainer getCraftMatrix() {
        GridCraftingInventory craftMatrix = new GridCraftingInventory();
        for (int i = 0; i < 9; ++i) {
            craftMatrix.m_6836_(i, this.items[i]);
        }
        return craftMatrix;
    }

    private void doCraft(CraftingRecipe recipe, ItemStack mresult, CraftingContainer craftMatrix, Player player) {
        int i;
        this.giveOrDropItem(mresult, player);
        mresult.m_41678_(this.f_58857_, player, mresult.m_41613_());
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)mresult, (Container)craftMatrix);
        if (!recipe.m_5598_()) {
            player.m_7281_(Collections.singleton(recipe));
        }
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList remaining = recipe.m_7457_((Container)craftMatrix);
        ForgeHooks.setCraftingPlayer(null);
        for (i = 0; i < remaining.size(); ++i) {
            ItemStack invStack = craftMatrix.m_8020_(i);
            ItemStack remStack = (ItemStack)remaining.get(i);
            if (!invStack.m_41619_()) {
                craftMatrix.m_7407_(i, 1);
                invStack = craftMatrix.m_8020_(i);
            }
            if (remStack.m_41619_()) continue;
            if (invStack.m_41619_()) {
                craftMatrix.m_6836_(i, remStack);
                continue;
            }
            if (ItemStack.m_150942_((ItemStack)invStack, (ItemStack)remStack)) {
                remStack.m_41769_(invStack.m_41613_());
                craftMatrix.m_6836_(i, remStack);
                continue;
            }
            this.giveOrDropItem(remStack, player);
        }
        for (i = 0; i < 9; ++i) {
            this.items[i] = craftMatrix.m_8020_(i);
        }
    }

    private void rotateItems(CraftingContainer inv) {
        int i;
        int[] slots = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
        ItemStack[] arrangement = new ItemStack[9];
        arrangement[4] = inv.m_8020_(4);
        for (i = 0; i < 8; ++i) {
            arrangement[slots[(i + 2) % 8]] = inv.m_8020_(slots[i]);
        }
        for (i = 0; i < 9; ++i) {
            inv.m_6836_(i, arrangement[i]);
        }
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)((double)(entity.m_146908_() * 4.0f / 360.0f) + 0.5) & 3;
    }

    private static class GridCraftingInventory
    extends InventorySimple
    implements CraftingContainer {
        public GridCraftingInventory() {
            super(9);
        }

        public int m_39347_() {
            return 3;
        }

        public int m_39346_() {
            return 3;
        }

        public List<ItemStack> m_280657_() {
            return Arrays.asList(this.items);
        }

        public void m_5809_(StackedContents pContents) {
            for (ItemStack item : this.items) {
                pContents.m_36466_(item);
            }
        }
    }
}

