/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.FacePart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.TickablePart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TranslocatorPart
extends BaseMultipart
implements FacePart,
NormalOcclusionPart,
TickablePart {
    public static final SoundType PLACEMENT_SOUND = new SoundType(1.0f, 1.0f, null, null, SoundEvents.f_12450_, null, null);
    public static Cuboid6 base = new Cuboid6(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
    public static Cuboid6[] boxes = new Cuboid6[6];
    public static Cuboid6[][] base_parts = new Cuboid6[6][4];
    public static VoxelShape baseShape = base.shape();
    public static VoxelShape[] boxShapes = new VoxelShape[6];
    public static VoxelShape[][] basePartShapes = new VoxelShape[6][4];
    public static VoxelShape[] basePartsJoined = new VoxelShape[6];
    public static int HIT_BASE = 0;
    public static int HIT_INSERT = 1;
    public byte side;
    public boolean a_eject = true;
    public boolean b_eject = true;
    public boolean redstone;
    public boolean invert_redstone = true;
    public boolean fast;
    public double a_insertpos = 1.0;
    public double b_insertpos = 1.0;

    public void save(CompoundTag tag) {
        tag.m_128344_("side", this.side);
        tag.m_128379_("invert_redstone", this.invert_redstone);
        tag.m_128379_("redstone", this.redstone);
        tag.m_128379_("fast", this.fast);
    }

    public void load(CompoundTag tag) {
        this.side = tag.m_128445_("side");
        this.invert_redstone = tag.m_128471_("invert_redstone");
        this.redstone = tag.m_128471_("redstone");
        this.fast = tag.m_128471_("fast");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.side);
        packet.writeByte(this.writeFlags());
    }

    public void readDesc(MCDataInput packet) {
        this.side = packet.readByte();
        this.readFlags(packet.readByte());
    }

    protected int writeFlags() {
        int flags = 0;
        flags |= this.a_eject ? 1 : 0;
        flags |= (this.redstone ? 1 : 0) << 1;
        return flags |= (this.fast ? 1 : 0) << 2;
    }

    protected void readFlags(int flags) {
        this.a_eject = (flags & 1) != 0;
        this.redstone = (flags & 2) != 0;
        this.fast = (flags & 4) != 0;
    }

    public final void readUpdate(MCDataInput packet) {
        byte flags = packet.readByte();
        this.readFlags(flags);
        if ((flags & 0x80) != 0) {
            this.readIncUpdate(packet);
        } else {
            this.onPartChanged((MultiPart)this);
            this.tile().markRender();
        }
    }

    public void sendFlagsUpdate() {
        this.sendUpdate(packet -> packet.writeByte(this.writeFlags()));
    }

    public void sendIncUpdate(Consumer<MCDataOutput> func) {
        this.sendUpdate(packet -> {
            packet.writeByte(this.writeFlags() | 0x80);
            func.accept((MCDataOutput)packet);
        });
    }

    public void readIncUpdate(MCDataInput packet) {
    }

    public void onPartChanged(MultiPart part) {
        if (!this.level().m_5776_()) {
            this.onNeighborBlockChanged(this.pos());
        }
        super.onPartChanged(part);
    }

    public SoundType getPlacementSound(UseOnContext context) {
        return PLACEMENT_SOUND;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public int getSlotMask() {
        return 1 << this.side;
    }

    public Cuboid6 getInsertBounds() {
        return new Cuboid6(0.375, 0.0, 0.375, 0.625, this.a_insertpos * 2.0 / 16.0 + 0.0625, 0.625).apply(Rotation.sideRotations[this.side].at(Vector3.CENTER));
    }

    public VoxelShape getShape(CollisionContext ctx) {
        return boxShapes[this.side];
    }

    public VoxelShape getOcclusionShape() {
        return boxShapes[this.side];
    }

    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return Shapes.m_83110_((VoxelShape)boxShapes[this.side], (VoxelShape)this.getInsertBounds().shape());
    }

    public VoxelShape getInteractionShape() {
        Cuboid6 insert = this.getInsertBounds();
        VoxelShape insertShape = insert.shape();
        return new MultiIndexedVoxelShape(Shapes.m_83110_((VoxelShape)basePartsJoined[this.side], (VoxelShape)insertShape), FastStream.of((Object[])basePartShapes[this.side]).map(e -> new IndexedVoxelShape(e, (Object)HIT_BASE)).concat((Iterable)FastStream.of((Object)new IndexedVoxelShape(insertShape, (Object)HIT_INSERT))).toImmutableSet());
    }

    public void onNeighborBlockChanged(BlockPos from) {
        if (!this.dropIfCantStay()) {
            this.sendFlagsUpdate();
        }
    }

    public void tick() {
        this.b_insertpos = this.a_insertpos;
        this.a_insertpos = MathHelper.approachExp((double)this.a_insertpos, (double)(this.a_eject ? 1.0 : 0.0), (double)0.5, (double)0.1);
        if (!this.level().m_5776_()) {
            this.b_eject = this.a_eject;
            boolean bl = this.a_eject = (this.redstone && this.level().m_276867_(this.pos())) != this.invert_redstone;
            if (this.a_eject != this.b_eject) {
                this.markUpdate();
            }
        }
    }

    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack held, InteractionHand hand) {
        if (this.level().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (held.m_41619_() && player.m_6047_()) {
            this.stripModifiers();
            this.markUpdate();
        } else if (held.m_41619_()) {
            if (hit.subHit == HIT_INSERT) {
                this.invert_redstone = !this.invert_redstone;
            } else {
                this.openGui(player);
            }
        } else if (held.m_41720_() == Items.f_42451_ && !this.redstone) {
            this.redstone = true;
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            if (this.level().m_276867_(this.pos()) == this.invert_redstone == this.a_eject) {
                this.invert_redstone = !this.invert_redstone;
            }
            this.markUpdate();
        } else if (held.m_41720_() == Items.f_42525_ && !this.fast) {
            this.fast = true;
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            this.markUpdate();
        } else {
            this.openGui(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void openGui(Player player) {
    }

    public void stripModifiers() {
        if (this.redstone) {
            this.redstone = false;
            this.dropItem(new ItemStack((ItemLike)Items.f_42451_));
            if (this.invert_redstone != this.a_eject) {
                boolean bl = this.invert_redstone = !this.invert_redstone;
            }
        }
        if (this.fast) {
            this.fast = false;
            this.dropItem(new ItemStack((ItemLike)Items.f_42525_));
        }
    }

    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getItem());
        if (this.redstone) {
            stacks.add(new ItemStack((ItemLike)Items.f_42451_));
        }
        if (this.fast) {
            stacks.add(new ItemStack((ItemLike)Items.f_42525_));
        }
        return stacks;
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        this.getDrops().forEach(this::dropItem);
        this.tile().remPart((MultiPart)this);
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getItem();
    }

    public abstract ItemStack getItem();

    public abstract int getTType();

    public abstract boolean canStay();

    public TranslocatorPart setupPlacement(Player player, Direction side) {
        this.side = (byte)(side.ordinal() ^ 1);
        return this;
    }

    public void markUpdate() {
        this.tile().m_6596_();
        this.tile().notifyPartChange((MultiPart)this);
        this.sendFlagsUpdate();
    }

    public boolean canEject() {
        if (!this.level().m_5776_()) {
            boolean b;
            boolean bl = b = (this.redstone && this.level().m_276867_(this.pos())) != this.invert_redstone;
            if (b != this.a_eject) {
                return b;
            }
        }
        return this.a_eject;
    }

    public boolean canConnect(int side) {
        MultiPart other = this.tile().getSlottedPart(side);
        return other instanceof TranslocatorPart && this.getTType() == ((TranslocatorPart)other).getTType();
    }

    public boolean canInsert(int side) {
        return this.canConnect(side) && !((TranslocatorPart)this.tile().getSlottedPart(side)).canEject();
    }

    public <T> T getOther(int side) {
        return (T)this.tile().getSlottedPart(side);
    }

    protected void dropItem(ItemStack stack) {
        TileMultipart.dropItem((ItemStack)stack, (Level)this.level(), (Vector3)Vector3.fromTileCenter((BlockEntity)this.tile()));
    }

    public int getIconIndex() {
        int i = 0;
        if (this.redstone) {
            i |= this.level().m_276867_(this.pos()) ? 2 : 1;
        }
        if (this.fast) {
            i |= 4;
        }
        return i;
    }

    public Cuboid6 getRenderBounds() {
        return boxes[this.side];
    }

    static {
        for (int i = 0; i < 6; ++i) {
            double d1 = 0.1875;
            double x1 = TranslocatorPart.base.min.x;
            double y1 = TranslocatorPart.base.min.y;
            double z1 = TranslocatorPart.base.min.z;
            double x2 = TranslocatorPart.base.max.x;
            double y2 = TranslocatorPart.base.max.y;
            double z2 = TranslocatorPart.base.max.z;
            Transformation rt = Rotation.sideRotations[i].at(Vector3.CENTER);
            TranslocatorPart.boxes[i] = base.copy().apply(rt);
            TranslocatorPart.base_parts[i] = new Cuboid6[]{new Cuboid6(x1, y1, z1, x1 + d1, y2, z2).apply(rt), new Cuboid6(x2 - d1, y1, z1, x2, y2, z2).apply(rt), new Cuboid6(x1 + d1, y1, z1, x2 - d1, y2, z1 + d1).apply(rt), new Cuboid6(x1 + d1, y1, z2 - d1, x2 - d1, y2, z2).apply(rt)};
            TranslocatorPart.boxShapes[i] = boxes[i].shape();
            TranslocatorPart.basePartShapes[i] = (VoxelShape[])Arrays.stream(base_parts[i]).map(Cuboid6::shape).toArray(VoxelShape[]::new);
            TranslocatorPart.basePartsJoined[i] = Arrays.stream(basePartShapes[i]).reduce(Shapes.m_83040_(), Shapes::m_83110_);
        }
    }
}

