/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.init;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.translocators.client.gui.GuiTranslocator;
import codechicken.translocators.client.render.FluidTranslocatorPartRenderer;
import codechicken.translocators.client.render.ItemTranslocatorPartRenderer;
import codechicken.translocators.client.render.RenderTranslocatorItem;
import codechicken.translocators.client.render.TileCraftingGridRenderer;
import codechicken.translocators.handler.CraftingGridKeyHandler;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.init.TranslocatorsModContent;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final ModelRegistryHelper modelHelper = new ModelRegistryHelper();

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientInit::clientSetup);
        bus.addListener(ClientInit::registerRenderers);
        CraftingGridKeyHandler.init(bus);
        TranslocatorTextures.init(bus);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)TranslocatorsModContent.containerItemTranslocator.get()), GuiTranslocator::new);
        ModelResourceLocation itemTranslocatorInv = new ModelResourceLocation(TranslocatorsModContent.itemTranslocatorItem.getId(), "inventory");
        ModelResourceLocation fluidTranslocatorInv = new ModelResourceLocation(TranslocatorsModContent.fluidTranslocatorItem.getId(), "inventory");
        modelHelper.register(itemTranslocatorInv, (BakedModel)new RenderTranslocatorItem(0));
        modelHelper.register(fluidTranslocatorInv, (BakedModel)new RenderTranslocatorItem(1));
        MultipartClientRegistry.register((MultipartType)((MultipartType)TranslocatorsModContent.itemTranslocatorPartType.get()), (PartRenderer)new ItemTranslocatorPartRenderer());
        MultipartClientRegistry.register((MultipartType)((MultipartType)TranslocatorsModContent.fluidTranslocatorPartType.get()), (PartRenderer)new FluidTranslocatorPartRenderer());
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TranslocatorsModContent.tileCraftingGridType.get(), TileCraftingGridRenderer::new);
    }
}

