/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.client.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.CustomGradient;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartRayTraceResult;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.part.TranslocatorPart;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;

public class TranslocatorPartRenderer<T extends TranslocatorPart>
implements PartRenderer<T> {
    protected static final Vector3[] sidePos = new Vector3[]{new Vector3(0.5, 0.0, 0.5), new Vector3(0.5, 1.0, 0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.5, 1.0), new Vector3(0.0, 0.5, 0.5), new Vector3(1.0, 0.5, 0.5)};
    protected static final Vector3[] sideVec = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    private static final CustomGradient gradient = new CustomGradient(new ResourceLocation("translocators", "textures/fx/grad.png"));
    private static final RenderType ITEM_RENDER_TYPE = RenderType.m_110446_((ResourceLocation)TextureAtlas.f_118259_);
    private static final RenderType particleType = RenderType.m_173209_((String)"translocator_link", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)255, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173103_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("translocators", "textures/fx/particle.png"), false, false)).m_110685_(RenderType.f_110139_).m_110671_(RenderType.f_110152_).m_110691_(false));
    private static final CCModel[] plates = new CCModel[6];
    private static final CCModel insert;

    public void renderStatic(T part, @Nullable RenderType layer, CCRenderState ccrs) {
        Vector3 trans = Vector3.CENTER;
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[((TranslocatorPart)((Object)part)).getTType()][((TranslocatorPart)((Object)part)).getIconIndex()]);
        ccrs.reset();
        ccrs.setBrightness((BlockAndTintGetter)part.level(), part.pos());
        plates[((TranslocatorPart)((Object)part)).side].render(ccrs, new IVertexOperation[]{trans.translation(), i_trans, ccrs.lightMatrix});
    }

    public void renderDynamic(T part, PoseStack pStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        BlockPos pos = part.pos();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        double insertpos = MathHelper.interpolate((double)((TranslocatorPart)((Object)part)).b_insertpos, (double)((TranslocatorPart)((Object)part)).a_insertpos, (double)partialTicks);
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[((TranslocatorPart)((Object)part)).getTType()][((TranslocatorPart)((Object)part)).getIconIndex()]);
        ccrs.reset();
        ccrs.bind(RenderType.m_110451_(), buffers, pStack);
        ccrs.lightMatrix.locate((BlockAndTintGetter)part.level(), pos);
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        Matrix4 mat = new Matrix4().translate(Vector3.CENTER).apply(Rotation.sideRotations[((TranslocatorPart)((Object)part)).side]).translate(new Vector3(0.0, -0.5, 0.0)).scale(1.0, insertpos * 2.0 / 3.0 + 0.3333333333333333, 1.0);
        insert.render(ccrs, new IVertexOperation[]{mat, i_trans, ccrs.lightMatrix});
        ccrs.reset();
        TranslocatorPartRenderer.renderLinks(part, ccrs, pStack, buffers);
    }

    public boolean drawHighlight(T part, PartRayTraceResult hit, Camera camera, PoseStack pStack, MultiBufferSource buffers, float partialTicks) {
        if (hit.subHit != TranslocatorPart.HIT_INSERT) {
            return false;
        }
        RenderUtils.bufferHitbox((Matrix4)new Matrix4(pStack).translate((Vec3i)hit.m_82425_()), (MultiBufferSource)buffers, (Camera)camera, (Cuboid6)((TranslocatorPart)((Object)part)).getInsertBounds());
        return true;
    }

    public static void renderItem(int type, PoseStack pStack, ItemDisplayContext ctx, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(ITEM_RENDER_TYPE, buffers);
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[type][0]);
        Vector3 v_trans = Vector3.CENTER.copy().add(0.0, 0.0, 0.5);
        if (ctx == ItemDisplayContext.GROUND) {
            v_trans.subtract(0.0, 0.5, 0.0);
        }
        Matrix4 mat = new Matrix4(pStack);
        Matrix4 i_matrix = mat.copy().translate(v_trans).apply(Rotation.sideRotations[2]).translate(new Vector3(0.0, -0.5, 0.0)).scale(new Vector3(1.0, 1.0, 1.0));
        mat.translate(v_trans);
        plates[2].render(ccrs, new IVertexOperation[]{mat, i_trans});
        insert.render(ccrs, new IVertexOperation[]{i_matrix, i_trans});
        ccrs.reset();
    }

    private static void renderLinks(TranslocatorPart p, CCRenderState ccrs, PoseStack pStack, MultiBufferSource buffers) {
        double time = ClientUtils.getRenderTime();
        TileMultipart tile = p.tile();
        if (p.a_eject) {
            Matrix4 mat = new Matrix4(pStack);
            ccrs.bind(particleType, buffers);
            for (int dst = 0; dst < 6; ++dst) {
                TranslocatorPart p_dst;
                if (dst == p.side || !p.canConnect(dst) || (p_dst = (TranslocatorPart)tile.getSlottedPart(dst)).canEject()) continue;
                TranslocatorPartRenderer.renderLink(ccrs, mat, p.side, dst, time);
            }
        }
    }

    private static void renderLink(CCRenderState ccrs, Matrix4 mat, int src, int dst, double time) {
        double d = (time + (double)src + (double)(dst * 2)) % 10.0 / 6.0;
        for (int n = 0; n < 20; ++n) {
            double dn = d - (double)n * 0.1;
            int spriteX = (int)(7.0 - (double)n * 1.5 - d * 2.0);
            if (!MathHelper.between((double)0.0, (double)dn, (double)1.0) || spriteX < 0) continue;
            Vector3 pos = TranslocatorPartRenderer.getPath(src, dst, dn);
            double b = 1.0;
            double s = 1.0;
            double u1 = (double)spriteX / 8.0;
            double u2 = u1 + 0.125;
            double v1 = 0.0;
            double v2 = 1.0;
            TranslocatorPartRenderer.renderParticle(ccrs, mat.copy().translate(pos), gradient.getColour((dn - 0.5) * 1.2 + 0.5).multiplyC(b), s * 0.12, u1, v1, u2, v2);
        }
    }

    public static void renderParticle(CCRenderState ccrs, Matrix4 mat, Colour colour, double s, double u1, double v1, double u2, double v2) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double rotationX = Math.cos((double)camera.m_90590_() * 0.017453292519943);
        double rotationZ = Math.sin((double)camera.m_90590_() * 0.017453292519943);
        double rotationYZ = -rotationZ * Math.sin((double)camera.m_90589_() * 0.017453292519943);
        double rotationXY = rotationX * Math.sin((double)camera.m_90589_() * 0.017453292519943);
        double rotationXZ = Math.cos((double)camera.m_90589_() * 0.017453292519943);
        ccrs.colour = colour.rgba();
        ccrs.vert.set(-rotationX * s - rotationYZ * s, -rotationXZ * s, -rotationZ * s - rotationXY * s, u2, v2).apply((Transformation)mat);
        ccrs.writeVert();
        ccrs.vert.set(-rotationX * s + rotationYZ * s, rotationXZ * s, -rotationZ * s + rotationXY * s, u2, v1).apply((Transformation)mat);
        ccrs.writeVert();
        ccrs.vert.set(rotationX * s + rotationYZ * s, rotationXZ * s, rotationZ * s + rotationXY * s, u1, v1).apply((Transformation)mat);
        ccrs.writeVert();
        ccrs.vert.set(rotationX * s - rotationYZ * s, -rotationXZ * s, rotationZ * s - rotationXY * s, u1, v2).apply((Transformation)mat);
        ccrs.writeVert();
    }

    public static Vector3 getPath(int src, int dst, double d) {
        Vector3 v;
        if ((src ^ 1) == dst) {
            v = sideVec[src ^ 1].copy().multiply(d);
        } else {
            Vector3 vsrc = sideVec[src ^ 1];
            Vector3 vdst = sideVec[dst ^ 1];
            Vector3 a = vsrc.copy().multiply(0.3125);
            Vector3 b = vdst.copy().multiply(0.375);
            double sind = Math.sin(d * Math.PI / 2.0);
            double cosd = Math.cos(d * Math.PI / 2.0);
            v = a.multiply(sind).add(b.multiply(cosd - 1.0)).add(vsrc.copy().multiply(0.1875));
        }
        return v.add(sidePos[src]);
    }

    public static Vector3 getPerp(int src, int dst) {
        if ((src ^ 1) == dst) {
            return sideVec[(src + 2) % 6].copy();
        }
        for (int i = 0; i < 3; ++i) {
            if (i == src / 2 || i == dst / 2) continue;
            return sideVec[i * 2].copy();
        }
        return null;
    }

    static {
        Map models = new OBJParser(new ResourceLocation("translocators", "models/model.obj")).ignoreMtl().quads().swapYZ().parse();
        TranslocatorPartRenderer.plates[0] = (CCModel)models.get("Plate");
        insert = (CCModel)models.get("Insert");
        CCModel.generateSidedModels((CCModel[])plates, (int)0, (Vector3)new Vector3());
    }
}

