/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.trades;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import tfar.shippingbin.inventory.CommonHandler;
import tfar.shippingbin.network.client.S2CCompletedTradesPacket;
import tfar.shippingbin.platform.Services;
import tfar.shippingbin.trades.CompletedTrade;
import tfar.shippingbin.trades.Trade;

public class TradeMatcher {
    public List<ItemStack> inputItems = new ArrayList<ItemStack>();

    public void account(ItemStack stack) {
        for (ItemStack ex : this.inputItems) {
            if (!ItemStack.m_150942_((ItemStack)ex, (ItemStack)stack)) continue;
            ex.m_41769_(stack.m_41613_());
            return;
        }
        this.inputItems.add(stack);
    }

    public int countTrades(Trade trade, boolean consume) {
        List<ItemStack> copy = TradeMatcher.deepCopy(this.inputItems);
        int c = 0;
        for (ItemStack stack : copy) {
            if (!trade.matches(stack)) continue;
            while (trade.matches(stack)) {
                ++c;
                stack.m_41774_(trade.count());
            }
        }
        return c;
    }

    public boolean canOutputFit(CommonHandler commonHandler, ItemStack stack) {
        return commonHandler.$slotlessInsertStack(stack, stack.m_41613_(), true).m_41619_();
    }

    public void trySellItems(CommonHandler input, CommonHandler output, Map<ResourceLocation, Integer> counts, Map<ResourceLocation, Trade> trades, @Nullable ServerPlayer player, double multiplier) {
        ArrayList<CompletedTrade> completedTrades = new ArrayList<CompletedTrade>();
        for (Map.Entry<ResourceLocation, Integer> entry : counts.entrySet()) {
            Trade trade = trades.get(entry.getKey());
            int tradeCount = entry.getValue();
            if (trade == null) continue;
            ItemStack tradeOutput = this.getTradeOutput(trade, tradeCount);
            this.applyMultipliers(tradeOutput, (Player)player, multiplier, trade.attribute());
            if (tradeOutput.m_41619_() || !this.canOutputFit(output, tradeOutput)) continue;
            List<ItemStack> soldItems = TradeMatcher.removeMatchingItems(input, trade.input(), trade.count() * tradeCount);
            MutableComponent listComponent = Component.m_237119_();
            boolean isFirst = true;
            for (ItemStack stack : soldItems) {
                if (!isFirst) {
                    listComponent.m_130946_(",");
                }
                listComponent.m_7220_(stack.m_41786_());
                isFirst = false;
            }
            completedTrades.add(new CompletedTrade((Component)Component.m_237110_((String)"shippingbin.toast.trade", (Object[])new Object[]{tradeCount * trade.count(), listComponent, tradeOutput.m_41613_(), tradeOutput.m_41786_()}), soldItems.isEmpty() ? ItemStack.f_41583_ : soldItems.get(0).m_255036_(1)));
            output.$slotlessInsertStack(tradeOutput, tradeOutput.m_41613_(), false);
        }
        if (player != null && !completedTrades.isEmpty()) {
            Services.PLATFORM.sendToClient(new S2CCompletedTradesPacket(completedTrades), player);
        }
    }

    void applyMultipliers(ItemStack stack, @Nullable Player player, double multiplier, @Nullable Attribute attribute) {
        double attributeMultiplier = player != null && attribute != null && player.m_21051_(attribute) != null ? player.m_21051_(attribute).m_22135_() : 1.0;
        double totalMultiplier = attributeMultiplier * multiplier;
        stack.m_41764_((int)((double)stack.m_41613_() * totalMultiplier));
    }

    public static List<ItemStack> removeMatchingItems(CommonHandler handler, Ingredient ingredient, int count) {
        int remaining = count;
        ArrayList<ItemStack> removed = new ArrayList<ItemStack>();
        for (int i = handler.$getSlotCount() - 1; i > -1; --i) {
            ItemStack stack = handler.$getStack(i);
            if (!ingredient.test(stack)) continue;
            if (remaining <= stack.m_41613_()) {
                TradeMatcher.account(stack.m_255036_(remaining), removed);
                stack.m_41774_(remaining);
                return removed;
            }
            TradeMatcher.account(stack, removed);
            remaining -= stack.m_41613_();
            handler.$setStack(i, ItemStack.f_41583_);
        }
        return removed;
    }

    public static void account(ItemStack stack, List<ItemStack> inputItems) {
        for (ItemStack ex : inputItems) {
            if (!ItemStack.m_150942_((ItemStack)ex, (ItemStack)stack)) continue;
            ex.m_41769_(stack.m_41613_());
            return;
        }
        inputItems.add(stack);
    }

    public ItemStack getTradeOutput(Trade trade, int count) {
        if (count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = trade.output().m_41777_();
        copy.m_41764_(copy.m_41613_() * count);
        return copy;
    }

    static List<ItemStack> deepCopy(List<ItemStack> list) {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>(list.size());
        for (ItemStack stack : list) {
            copy.add(stack.m_41777_());
        }
        return copy;
    }
}

