/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.datagen.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import tfar.shippingbin.datagen.data.FinishedTrade;

public class TradeBuilder {
    private final ItemStack result;
    private final int count;
    private final Ingredient ingredient;
    @Nullable
    Attribute attribute;

    public TradeBuilder(ItemStack stack, Ingredient ingredient, int count) {
        this.result = stack;
        this.ingredient = ingredient;
        this.count = count;
    }

    public static TradeBuilder builder(ItemLike output, ItemLike input) {
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{input});
        ItemStack stack = new ItemStack(output);
        return TradeBuilder.builderWithCount(stack, ingredient, 1);
    }

    public static TradeBuilder builderWithCount(ItemStack output, Ingredient input, int count) {
        return new TradeBuilder(output, input, count);
    }

    public static TradeBuilder builderWithCount(ItemLike output, Ingredient input, int count) {
        return new TradeBuilder(output.m_5456_().m_7968_(), input, count);
    }

    public static TradeBuilder builderWithCount(ItemLike output, TagKey<Item> input, int count) {
        return new TradeBuilder(output.m_5456_().m_7968_(), Ingredient.m_204132_(input), count);
    }

    public static TradeBuilder builderWithCount(ItemLike output, Item input, int count) {
        return TradeBuilder.builderWithCount(new ItemStack(output), Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), count);
    }

    public TradeBuilder setAttribute(@Nullable Attribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public void save(Consumer<FinishedTrade> consumer, ResourceLocation pRecipeId) {
        consumer.accept(new Result(pRecipeId, this.result, this.ingredient, this.count, this.attribute));
    }

    public void save(Consumer<FinishedTrade> consumer) {
        this.save(consumer, TradeBuilder.getDefaultTradeId((ItemLike)this.result.m_41720_()));
    }

    static ResourceLocation getDefaultTradeId(ItemLike pItemLike) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)pItemLike.m_5456_());
    }

    public static class Result
    implements FinishedTrade {
        private final ResourceLocation tradeId;
        private final ItemStack result;
        private final Ingredient ingredient;
        private final int count;
        @Nullable
        private final Attribute attribute;

        public Result(ResourceLocation tradeId, ItemStack result, Ingredient ingredient, int count, @Nullable Attribute attribute) {
            this.tradeId = tradeId;
            this.result = result;
            this.ingredient = ingredient;
            this.count = count;
            this.attribute = attribute;
        }

        @Override
        public void serializeRecipeData(JsonObject pJson) {
            JsonObject input = new JsonObject();
            input.add("ingredient", this.ingredient.m_43942_());
            input.addProperty("count", (Number)this.count);
            pJson.add("input", (JsonElement)input);
            pJson.add("output", (JsonElement)Result.writeStack(this.result));
            if (this.attribute != null) {
                pJson.addProperty("attribute", BuiltInRegistries.f_256951_.m_7981_((Object)this.attribute).toString());
            }
        }

        public static JsonObject writeStack(ItemStack stack) {
            Item item = stack.m_41720_();
            String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", itemName);
            if (stack.m_41782_()) {
                jsonObject.addProperty("nbt", stack.m_41783_().toString());
            }
            jsonObject.addProperty("count", (Number)stack.m_41613_());
            return jsonObject;
        }

        @Override
        public ResourceLocation getId() {
            return this.tradeId;
        }
    }
}

