/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.datagen;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;
import tfar.shippingbin.Utils;
import tfar.shippingbin.init.ModAttributes;
import tfar.shippingbin.init.ModBlocks;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(PackOutput output) {
        super(output, "shippingbin", "en_us");
    }

    protected void addTranslations() {
        this.addDefaultBlock(() -> ModBlocks.SHIPPING_BIN);
        this.addTextComponent(Utils.TRADING, "Trading");
        this.add("category.shippingbin.trading.attribute", "Bonus: %s");
        this.add("shippingbin.toast.trade", "Sold %s %s for %s %s");
        this.addAttribute(ModAttributes.SELL_MULTIPLIER, "Sell Multiplier");
        this.addAttribute(ModAttributes.WOOD_SELL_MULTIPLIER, "Wood Sell Multiplier");
        this.addAttribute(ModAttributes.GEM_SELL_MULTIPLIER, "Gem Sell Multiplier");
        this.addAttribute(ModAttributes.MEAT_SELL_MULTIPLIER, "Meat Sell Multiplier");
        this.addAttribute(ModAttributes.CROP_SELL_MULTIPLIER, "Crop Sell Multiplier");
    }

    protected void addTextComponent(MutableComponent component, String text) {
        ComponentContents contents = component.m_214077_();
        if (!(contents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException(component + " is not translatable");
        }
        TranslatableContents translatableContents = (TranslatableContents)contents;
        this.add(translatableContents.m_237508_(), text);
    }

    protected void addAttribute(Attribute attribute, String key) {
        this.add(attribute.m_22087_(), key);
    }

    protected void addDefaultItem(Supplier<? extends Item> supplier) {
        this.addItem(supplier, ModLangProvider.getNameFromItem(supplier.get()));
    }

    protected void addDefaultBlock(Supplier<? extends Block> supplier) {
        this.addBlock(supplier, ModLangProvider.getNameFromBlock(supplier.get()));
    }

    protected void addDefaultEnchantment(Supplier<? extends Enchantment> supplier) {
        this.addEnchantment(supplier, ModLangProvider.getNameFromEnchantment(supplier.get()));
    }

    protected void addDefaultEntityType(Supplier<EntityType<?>> supplier) {
        this.addEntityType(supplier, ModLangProvider.getNameFromEntity(supplier.get()));
    }

    public static String getNameFromItem(Item item) {
        return StringUtils.capitaliseAllWords((String)item.m_5524_().split("\\.")[2].replace("_", " "));
    }

    public static String getNameFromBlock(Block block) {
        return StringUtils.capitaliseAllWords((String)block.m_7705_().split("\\.")[2].replace("_", " "));
    }

    public static String getNameFromEnchantment(Enchantment enchantment) {
        return StringUtils.capitaliseAllWords((String)enchantment.m_44704_().split("\\.")[2].replace("_", " "));
    }

    public static String getNameFromEntity(EntityType<?> entity) {
        return StringUtils.capitaliseAllWords((String)entity.m_20675_().split("\\.")[2].replace("_", " "));
    }
}

