/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.structure;

import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.loot.RandomDye;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TailorShopProcessor
extends StructureProcessor {
    public static final Codec<TailorShopProcessor> CODEC = Codec.EMPTY.xmap(u -> new TailorShopProcessor(), p -> Unit.INSTANCE).codec();

    public static Codec<TailorShopProcessor> codec() {
        return CODEC;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)SewingKitMod.TAILOR_SHOP_PROCESSOR.get();
    }

    @Nullable
    public StructureTemplate.StructureEntityInfo processEntity(LevelReader world, BlockPos seedPos, StructureTemplate.StructureEntityInfo rawEntityInfo, StructureTemplate.StructureEntityInfo entityInfo, StructurePlaceSettings placementSettings, StructureTemplate template) {
        String id = entityInfo.f_74685_.m_128461_("id");
        if (Objects.equals(id, "minecraft:armor_stand")) {
            RandomSource s = placementSettings.m_230326_(entityInfo.f_74684_);
            if (s.m_188500_() < 0.1) {
                return null;
            }
            entityInfo = new StructureTemplate.StructureEntityInfo(entityInfo.f_74683_, entityInfo.f_74684_, entityInfo.f_74685_.m_6426_());
            ListTag armorTag = entityInfo.f_74685_.m_128437_("ArmorItems", 10);
            if (!entityInfo.f_74685_.m_128425_("ArmorItems", 9)) {
                entityInfo.f_74685_.m_128365_("ArmorItems", (Tag)armorTag);
            }
            this.putArmorPieceMaybe(armorTag, 3, s, Items.f_42407_, (Item)SewingKitMod.WOOL_HAT.get());
            this.putArmorPieceMaybe(armorTag, 2, s, Items.f_42408_, (Item)SewingKitMod.WOOL_SHIRT.get());
            this.putArmorPieceMaybe(armorTag, 1, s, Items.f_42462_, (Item)SewingKitMod.WOOL_PANTS.get());
            this.putArmorPieceMaybe(armorTag, 0, s, Items.f_42463_, (Item)SewingKitMod.WOOL_SHOES.get());
        }
        return entityInfo;
    }

    private void putArmorPieceMaybe(ListTag armorTag, int index, RandomSource rand, Item ... items) {
        if (items.length > 0 && rand.m_188500_() < 0.25) {
            Item item = items[rand.m_188503_(items.length)];
            ItemStack stack = RandomDye.getRandomDye(new ItemStack((ItemLike)item), rand);
            armorTag.set(index, (Tag)stack.m_41739_(new CompoundTag()));
        }
    }
}

