/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2.tags;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.impl.core.CommonFactories;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractTagProvider<T>
extends TagsProvider<T> {
    protected final String modId;

    public AbstractTagProvider(ResourceKey<? extends Registry<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getModId(), context.getPackOutput(), context.getLookupProvider());
    }

    public AbstractTagProvider(ResourceKey<? extends Registry<T>> registryKey, String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registryKey, registries);
        this.modId = modId;
    }

    static <T> AbstractTagAppender<T> tagAppender(TagBuilder tagBuilder, ResourceKey<? extends Registry<? super T>> registryKey) {
        Optional optional = AbstractTagProvider.getRegistry(registryKey);
        Function<Object, ResourceKey> keyExtractor = optional.isPresent() ? t -> (ResourceKey)optional.flatMap(registry -> registry.m_7854_(t)).orElseThrow(() -> new IllegalStateException("Missing value in " + registryKey + ": " + t)) : null;
        return CommonFactories.INSTANCE.getTagAppender(tagBuilder, keyExtractor);
    }

    static <T> Optional<Registry<T>> getRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return BuiltInRegistries.f_257047_.m_123009_(registryKey);
    }

    public abstract void m_6577_(HolderLookup.Provider var1);

    @ApiStatus.Internal
    public TagsProvider.TagAppender<T> m_206424_(TagKey<T> tagKey) {
        throw new UnsupportedOperationException();
    }

    public AbstractTagAppender<T> add(String string) {
        return this.add(ResourceLocationHelper.parse(string));
    }

    public AbstractTagAppender<T> add(ResourceLocation resourceLocation) {
        return this.add(TagKey.m_203882_((ResourceKey)this.f_254716_, (ResourceLocation)resourceLocation));
    }

    public AbstractTagAppender<T> add(TagKey<T> tagKey) {
        return AbstractTagProvider.tagAppender(this.m_236451_(tagKey), this.f_254716_);
    }
}

