/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network;

import com.blackgear.platform.core.network.PacketRegistry;
import com.blackgear.platform.core.network.base.NetworkDirection;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketHandler;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;

public class NetworkChannel {
    private final ResourceLocation channel;

    public NetworkChannel(String modId, int version, String channel) {
        this.channel = new ResourceLocation(modId, channel);
        PacketRegistry.registerChannel(this.channel, version);
    }

    public <T extends Packet<T>> void registerPacket(NetworkDirection direction, ResourceLocation id, PacketHandler<T> handler, Class<T> packet) {
        if (direction == NetworkDirection.TO_SERVER) {
            PacketRegistry.registerServerbound(this.channel, id, handler, packet);
        } else {
            PacketRegistry.registerClientbound(this.channel, id, handler, packet);
        }
    }

    public <T extends Packet<T>> void sendToServer(T packet) {
        PacketRegistry.sendToServer(this.channel, packet);
    }

    public <T extends Packet<T>> void sendToPlayer(T packet, Player player) {
        PacketRegistry.sendToPlayer(this.channel, packet, player);
    }

    public <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends Player> players) {
        players.forEach(player -> this.sendToPlayer(packet, (Player)player));
    }

    public <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.m_6846_().m_11314_());
    }

    public <T extends Packet<T>> void sendToPlayersInLevel(T packet, Level level) {
        this.sendToPlayers(packet, level.m_6907_());
    }

    public <T extends Packet<T>> void sendToAllLoadedPlayers(T packet, Level level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            cache.f_8325_.m_183262_(chunk.m_7697_(), false).forEach(player -> this.sendToPlayer(packet, (Player)player));
        }
    }

    public <T extends Packet<T>> void sendToPlayersInRange(T packet, Level level, BlockPos pos, double range) {
        level.m_6907_().stream().filter(player -> player.m_20183_().m_123331_((Vec3i)pos) <= range).forEach(player -> this.sendToPlayer(packet, (Player)player));
    }
}

