/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.capability;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.Serde;
import tictim.paraglider.impl.movement.PlayerMovement;

public class PlayerMovementProvider
implements ICapabilityProvider {
    public static final Capability<PlayerMovement> PLAYER_MOVEMENT = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerMovement>(){});
    public final PlayerMovement movement;
    @Nullable
    private LazyOptional<PlayerMovement> self;

    @NotNull
    public static PlayerMovementProvider create(@NotNull PlayerMovement movement) {
        Objects.requireNonNull(movement);
        return movement instanceof Serde ? new Serializable(movement) : new PlayerMovementProvider(movement);
    }

    private PlayerMovementProvider(@NotNull PlayerMovement movement) {
        this.movement = movement;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction arg) {
        if (cap == PLAYER_MOVEMENT) {
            if (this.self == null) {
                this.self = LazyOptional.of(() -> this.movement);
            }
            return this.self.cast();
        }
        return LazyOptional.empty();
    }

    @Nullable
    public static PlayerMovement of(@NotNull ICapabilityProvider capabilityProvider) {
        return (PlayerMovement)capabilityProvider.getCapability(PLAYER_MOVEMENT).orElse(null);
    }

    public static class Serializable
    extends PlayerMovementProvider
    implements ICapabilitySerializable<CompoundTag> {
        @NotNull
        private final Serde serde;

        private Serializable(@NotNull PlayerMovement movement) {
            super(movement);
            Serde s;
            if (!(movement instanceof Serde)) {
                throw new IllegalArgumentException("PlayerMovement does not implement Serde");
            }
            this.serde = s = (Serde)((Object)movement);
        }

        public CompoundTag serializeNBT() {
            return this.serde.write();
        }

        public void deserializeNBT(CompoundTag tag) {
            this.serde.read(tag);
        }
    }
}

