/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.content.block.LeadOreBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MoltenLeadBlock
extends LiquidBlock {
    public static final VoxelShape STABLE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty WAITING = BooleanProperty.m_61465_((String)"waiting");

    public MoltenLeadBlock(Supplier<? extends FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties.m_60910_().m_60913_(-1.0f, 3600000.0f).m_222994_().m_60953_(state -> 8));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WAITING, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.WALKABLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WAITING});
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60819_().m_76170_()) {
            FluidState oldFluid = oldState.m_60819_();
            if (oldFluid.m_205070_(FluidTags.f_13131_)) {
                level.m_46796_(1501, pos, 0);
                level.m_7731_(pos, ((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_49966_(), 3);
            } else if (oldFluid.m_205070_(FluidTags.f_13132_)) {
                LeadOreBlock.spawnCloud(level, pos, 2.0f);
                level.m_46597_(pos, oldState);
            }
        }
        if (((Boolean)state.m_61143_((Property)WAITING)).booleanValue()) {
            level.m_186460_(pos, state.m_60734_(), ((Integer)OreganizedConfig.COMMON.moltenLeadDelay.get()).intValue());
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context.m_7142_((Item)OItems.MOLTEN_LEAD_BUCKET.get())) {
            return level.m_8055_(pos.m_7494_()).m_60713_((Block)this) ? Shapes.m_83144_() : STABLE_SHAPE;
        }
        return Shapes.m_83040_();
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        if (this.getFluid() == fluid) {
            return false;
        }
        return super.m_5946_(state, fluid);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState replacedWith, boolean dropXp) {
        super.m_6810_(state, level, pos, replacedWith, dropXp);
        if (replacedWith.m_60795_() || !replacedWith.m_60819_().m_76178_()) {
            return;
        }
        if (replacedWith.m_60713_((Block)OBlocks.LEAD_BLOCK.get())) {
            return;
        }
        if (state.m_60819_().m_76170_()) {
            this.tryEscape(state, level, pos);
        }
    }

    private boolean tryEscape(BlockState state, Level level, BlockPos pos, Direction direction) {
        BlockPos adjancentPos = pos.m_121945_(direction);
        BlockState adjacentState = level.m_8055_(adjancentPos);
        if (adjacentState.m_60722_((Fluid)this.getFluid())) {
            level.m_46597_(adjancentPos, state);
            this.m_142298_().ifPresent(sound -> level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f));
            return true;
        }
        return false;
    }

    private boolean tryEscape(BlockState state, Level level, BlockPos pos) {
        if (this.tryEscape(state, level, pos, Direction.DOWN)) {
            return true;
        }
        for (Direction direction : Direction.m_235667_((RandomSource)level.f_46441_)) {
            if (!direction.m_122434_().m_122479_() || !this.tryEscape(state, level, pos, direction)) continue;
            return true;
        }
        return this.tryEscape(state, level, pos, Direction.UP);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_20186_() < (double)pos.m_123342_() + STABLE_SHAPE.m_83297_(Direction.Axis.Y)) {
            if (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this)) {
                entity.m_7601_(state, new Vec3((double)0.9f, 1.0, (double)0.9f));
            }
            entity.m_20254_(10);
            if (!world.f_46443_) {
                entity.m_146868_(true);
            }
        }
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if ((double)fallDistance >= 4.0 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity.Fallsounds fallSound = living.m_196493_();
            SoundEvent sound = (double)fallDistance < 7.0 ? fallSound.f_196626_() : fallSound.f_196627_();
            entity.m_5496_(sound, 1.0f, 1.0f);
        }
    }

    public static boolean isEntityLighterThanLead(Entity entity) {
        LivingEntity living;
        if (entity.m_6095_().m_204039_(OTags.Entities.LIGHTER_THAN_LEAD)) {
            return true;
        }
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6844_(EquipmentSlot.FEET).m_204117_(OTags.Items.LIGHTER_THAN_LEAD);
    }

    public static boolean shouldWait(LevelAccessor level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean moving) {
        super.m_6861_(state, level, pos, block, neighborPos, moving);
        Boolean waiting = (Boolean)state.m_61143_((Property)WAITING);
        boolean shouldWait = MoltenLeadBlock.shouldWait((LevelAccessor)level, pos);
        if (waiting == shouldWait) {
            return;
        }
        if (shouldWait) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)WAITING, (Comparable)Boolean.valueOf(true)));
        } else {
            level.m_186460_(pos, state.m_60734_(), ((Integer)OreganizedConfig.COMMON.moltenLeadDelay.get()).intValue());
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        if (!MoltenLeadBlock.shouldWait((LevelAccessor)level, pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)WAITING, (Comparable)Boolean.valueOf(false)));
        }
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.of(SoundEvents.f_11783_);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathFinder) {
        return true;
    }
}

