/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="oreganized")
public class OreganizedConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    private static final ForgeConfigSpec COMMON_SPEC;
    private static final ForgeConfigSpec CLIENT_SPEC;

    public static void register() {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        COMMON = (Common)commonSpecPair.getLeft();
        CLIENT = (Client)clientSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> poisonInsteadOfStunning;
        public final ForgeConfigSpec.ConfigValue<Boolean> leadDustCloud;
        public final ForgeConfigSpec.ConfigValue<Boolean> pillagerSpawnWithBolts;
        public final ForgeConfigSpec.ConfigValue<Boolean> scribeSilkTouchStone;
        public final ForgeConfigSpec.ConfigValue<Integer> moltenLeadDelay;
        public final ForgeConfigSpec.ConfigValue<Boolean> cauldronLeadMelting;

        private Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common");
            builder.push("common");
            this.poisonInsteadOfStunning = builder.comment("Should lead poisoning events give just Poison instead of Brain Damage?").define("poisonInsteadOfBrainDamage", false);
            this.leadDustCloud = builder.comment("Should lead ore spawn dust clouds when broken without adjacent water?").define("leadDustCloud", true);
            this.pillagerSpawnWithBolts = builder.comment("Pillagers have a chance to spawn with a lead bolt in their offhand").define("pillagerSpawnWithBolts", true);
            this.scribeSilkTouchStone = builder.comment("The scribe is able to silk-touch pickaxe-related blocks").define("scribeSilkTouchStone", true);
            this.moltenLeadDelay = builder.comment("Time in ticks molten lead waits until flowing downwards").defineInRange("moltenLeadDelay", 200, 0, 2000);
            this.cauldronLeadMelting = builder.comment("Can lead blocks be placed into a cauldron to melt?").define("cauldronLeadMelting", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> renderStunningOverlay;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client");
            builder.push("client");
            this.renderStunningOverlay = builder.comment("Should the custom overlay for the brain damage effect be rendered?").define("renderBrainDamageOverlay", true);
            builder.pop();
        }
    }
}

