/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.api.gui.widget;

import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.util.SessionUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class AuthButtonWidget
extends ImageButton {
    @Nullable
    private final Screen screen;
    @Nullable
    private final MoveAction moveAction;
    private boolean didDrag = false;
    private SessionUtils.SessionStatus sessionStatus = SessionUtils.SessionStatus.UNKNOWN;

    public AuthButtonWidget(int x, int y, Button.OnPress pressAction) {
        this(null, x, y, pressAction, null);
    }

    public AuthButtonWidget(int x, int y, Button.OnPress pressAction, @Nullable Component message) {
        this(null, x, y, pressAction, null, null, message);
    }

    public AuthButtonWidget(int x, int y, Button.OnPress pressAction, @Nullable Tooltip tooltip, @Nullable Component message) {
        this(null, x, y, pressAction, null, tooltip, message);
    }

    public AuthButtonWidget(@Nullable Screen screen, int x, int y, Button.OnPress pressAction, @Nullable MoveAction moveAction) {
        this(screen, x, y, pressAction, moveAction, (Component)Component.m_237115_((String)"gui.neo_auth.button.auth"));
    }

    public AuthButtonWidget(@Nullable Screen screen, int x, int y, Button.OnPress pressAction, @Nullable MoveAction moveAction, @Nullable Component message) {
        this(screen, x, y, pressAction, moveAction, null, message);
    }

    public AuthButtonWidget(@Nullable Screen screen, int x, int y, Button.OnPress pressAction, @Nullable MoveAction moveAction, @Nullable Tooltip tooltip, Component message) {
        super(x, y, 20, 20, 0, 146, 20, Button.f_93617_, 256, 256, pressAction, message);
        this.screen = screen;
        this.moveAction = moveAction;
        this.m_257544_(tooltip);
        this.refreshSessionStatus();
    }

    public SessionUtils.SessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public void refreshSessionStatus() {
        this.sessionStatus = SessionUtils.SessionStatus.UNKNOWN;
        SessionUtils.getStatus().thenAccept(status -> {
            this.sessionStatus = status;
        });
    }

    public void setSessionStatus(SessionUtils.SessionStatus sessionStatus) {
        this.sessionStatus = sessionStatus;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.moveAction != null) {
            return this.m_7972_(button) && this.m_93680_(mouseX, mouseY);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.moveAction == null) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        if (!this.m_7972_(button)) {
            return false;
        }
        if (this.didDrag) {
            this.moveAction.onMove((Button)this);
            this.didDrag = false;
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.moveAction != null) {
            this.didDrag = true;
            if (this.screen != null) {
                this.m_264152_(Math.min(Math.max(0, (int)mouseX - this.f_93618_ / 2), this.screen.f_96543_ - this.f_93618_), Math.min(Math.max(0, (int)mouseY - this.f_93619_ / 2), this.screen.f_96544_ - this.f_93619_));
            } else {
                this.m_264152_((int)mouseX - this.f_93618_ / 2, (int)mouseY - this.f_93619_ / 2);
            }
        }
        super.m_7212_(mouseX, mouseY, deltaX, deltaY);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_87963_(graphics, mouseX, mouseY, delta);
        graphics.m_280163_(NeoAuth.WIDGETS_TEXTURE, this.m_252754_() + this.f_93618_ - 6, this.m_252907_() - 1, (float)(switch (this.sessionStatus) {
            case SessionUtils.SessionStatus.VALID -> 0;
            case SessionUtils.SessionStatus.OFFLINE -> 8;
            default -> 16;
        }), 60.0f, 8, 8, 128, 128);
    }

    @FunctionalInterface
    public static interface MoveAction {
        public void onMove(Button var1);
    }
}

