/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.forge;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.ModConfig;
import dev.obscuria.lootjournal.ModConfigDefaults;
import dev.obscuria.lootjournal.client.ItemPolicy;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.PickupDrawStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.compress.utils.Lists;

public final class ForgeConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.EnumValue<PickupDrawStyle> STYLE;
    private static final ForgeConfigSpec.BooleanValue ITEM_ENTRY_DISPLAY;
    private static final ForgeConfigSpec.BooleanValue ITEM_ENTRY_DISPLAY_TOTAL_AMOUNT;
    private static final ForgeConfigSpec.BooleanValue ITEM_ENTRY_USE_ITEM_FORMATTING;
    private static final ForgeConfigSpec.ConfigValue<String> ITEM_ENTRY_COLOR;
    private static final ForgeConfigSpec.BooleanValue ITEM_ENTRY_ITALIC;
    private static final ForgeConfigSpec.BooleanValue AGGREGATED_ENTRY_DISPLAY;
    private static final ForgeConfigSpec.ConfigValue<String> AGGREGATED_ENTRY_COLOR;
    private static final ForgeConfigSpec.BooleanValue AGGREGATED_ENTRY_ITALIC;
    private static final ForgeConfigSpec.BooleanValue EXPERIENCE_ENTRY_DISPLAY;
    private static final ForgeConfigSpec.ConfigValue<String> EXPERIENCE_ENTRY_COLOR;
    private static final ForgeConfigSpec.BooleanValue EXPERIENCE_ENTRY_ITALIC;
    private static final ForgeConfigSpec.EnumValue<Anchor> ANCHOR;
    private static final ForgeConfigSpec.IntValue ANCHOR_PIXEL_OFFSET;
    private static final ForgeConfigSpec.IntValue ANCHOR_PERCENT_OFFSET;
    private static final ForgeConfigSpec.IntValue SCALE;
    private static final ForgeConfigSpec.IntValue SEPARATION;
    private static final ForgeConfigSpec.IntValue LIFETIME;
    private static final ForgeConfigSpec.IntValue DISPLAY_CAPACITY;
    private static final ForgeConfigSpec.IntValue QUEUE_CAPACITY;
    private static final ForgeConfigSpec.EnumValue<ItemPolicy> DEFAULT_ITEM_POLICY;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_ID_BLACKLIST;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_ID_WHITELIST;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MOD_ID_BLACKLIST;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MOD_ID_WHITELIST;

    public static void init(IEventBus eventBus) {
        eventBus.addListener(ForgeConfig::onUpdate);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "obscuria/loot_journal-client.toml");
    }

    public static void onUpdate(ModConfigEvent event) {
        LootJournal.CONFIG.style = (PickupDrawStyle)((Object)STYLE.get());
        LootJournal.CONFIG.itemEntryDisplay = (Boolean)ITEM_ENTRY_DISPLAY.get();
        LootJournal.CONFIG.itemEntryDisplayTotalAmount = (Boolean)ITEM_ENTRY_DISPLAY_TOTAL_AMOUNT.get();
        LootJournal.CONFIG.itemEntryUseItemFormatting = (Boolean)ITEM_ENTRY_USE_ITEM_FORMATTING.get();
        LootJournal.CONFIG.itemEntryStyle = ModConfig.createStyle((String)ITEM_ENTRY_COLOR.get(), (boolean)((Boolean)ITEM_ENTRY_ITALIC.get()));
        LootJournal.CONFIG.aggregatedEntryDisplay = (Boolean)AGGREGATED_ENTRY_DISPLAY.get();
        LootJournal.CONFIG.aggregatedEntryStyle = ModConfig.createStyle((String)AGGREGATED_ENTRY_COLOR.get(), (boolean)((Boolean)AGGREGATED_ENTRY_ITALIC.get()));
        LootJournal.CONFIG.experienceEntryDisplay = (Boolean)EXPERIENCE_ENTRY_DISPLAY.get();
        LootJournal.CONFIG.experienceEntryStyle = ModConfig.createStyle((String)EXPERIENCE_ENTRY_COLOR.get(), (boolean)((Boolean)EXPERIENCE_ENTRY_ITALIC.get()));
        LootJournal.CONFIG.anchor = (Anchor)((Object)ANCHOR.get());
        LootJournal.CONFIG.anchorPixelOffset = (Integer)ANCHOR_PIXEL_OFFSET.get();
        LootJournal.CONFIG.anchorPercentOffset = (Integer)ANCHOR_PERCENT_OFFSET.get();
        LootJournal.CONFIG.scale = (Integer)SCALE.get();
        LootJournal.CONFIG.separation = (Integer)SEPARATION.get();
        LootJournal.CONFIG.lifetime = (Integer)LIFETIME.get();
        LootJournal.CONFIG.displayCapacity = (Integer)DISPLAY_CAPACITY.get();
        LootJournal.CONFIG.queueCapacity = (Integer)QUEUE_CAPACITY.get();
        LootJournal.CONFIG.defaultItemPolicy = (ItemPolicy)((Object)DEFAULT_ITEM_POLICY.get());
        LootJournal.CONFIG.itemIdBlacklist = ModConfig.mapItems((List)ITEM_ID_BLACKLIST.get());
        LootJournal.CONFIG.itemIdWhitelist = ModConfig.mapItems((List)ITEM_ID_WHITELIST.get());
        LootJournal.CONFIG.modIdBlacklist = new ArrayList<String>((Collection)MOD_ID_BLACKLIST.get());
        LootJournal.CONFIG.modIdWhitelist = new ArrayList<String>((Collection)MOD_ID_WHITELIST.get());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Display Options");
        STYLE = builder.defineEnum("Message Style", (Enum)ModConfigDefaults.STYLE);
        builder.push("Item Pickup");
        ITEM_ENTRY_DISPLAY = builder.define("Show Item Pickups", true);
        ITEM_ENTRY_DISPLAY_TOTAL_AMOUNT = builder.define("Show Total Item Count", true);
        ITEM_ENTRY_USE_ITEM_FORMATTING = builder.define("Use Minecraft Formatting", true);
        ITEM_ENTRY_COLOR = builder.define("Text Color", (Object)ModConfig.intToHex(0xFFFFFF));
        ITEM_ENTRY_ITALIC = builder.define("Italic Text", false);
        builder.pop();
        builder.push("Aggregated Pickup");
        AGGREGATED_ENTRY_DISPLAY = builder.define("Show Aggregated Pickups", true);
        AGGREGATED_ENTRY_COLOR = builder.define("Text Color", (Object)ModConfig.intToHex(0xFFFFFF));
        AGGREGATED_ENTRY_ITALIC = builder.define("Italic Text", true);
        builder.pop();
        builder.push("Experience Pickup");
        EXPERIENCE_ENTRY_DISPLAY = builder.define("Show Experience Pickups", true);
        EXPERIENCE_ENTRY_COLOR = builder.define("Text Color", (Object)ModConfig.intToHex(0x55FF55));
        EXPERIENCE_ENTRY_ITALIC = builder.define("Italic Text", false);
        builder.pop();
        builder.pop();
        builder.push("Layout Options");
        ANCHOR = builder.defineEnum("Screen Position", (Enum)ModConfigDefaults.ANCHOR);
        ANCHOR_PIXEL_OFFSET = builder.defineInRange("Offset", 3, 0, 200);
        ANCHOR_PERCENT_OFFSET = builder.defineInRange("Relative Offset", 10, 0, 50);
        SCALE = builder.defineInRange("Message Scale", 100, 50, 100);
        SEPARATION = builder.defineInRange("Line Spacing", 3, 0, 16);
        LIFETIME = builder.defineInRange("Message Duration", 6, 0, 32);
        DISPLAY_CAPACITY = builder.defineInRange("Max Visible Messages", 9, 1, 64);
        QUEUE_CAPACITY = builder.defineInRange("Message Queue Size", 9, 0, 256);
        builder.pop();
        builder.push("Filter Options");
        DEFAULT_ITEM_POLICY = builder.defineEnum("Default Filter Rule", (Enum)ModConfigDefaults.DEFAULT_ITEM_POLICY);
        ITEM_ID_BLACKLIST = builder.defineList("Item ID Blacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        ITEM_ID_WHITELIST = builder.defineList("Item ID Whitelist", (List)Lists.newArrayList(), it -> it instanceof String);
        MOD_ID_BLACKLIST = builder.defineList("Mod ID Blacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        MOD_ID_WHITELIST = builder.defineList("Mod ID Whitelist", (List)Lists.newArrayList(), it -> it instanceof String);
        builder.pop();
        SPEC = builder.build();
    }
}

