/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.Window;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.AggregatedPickup;
import dev.obscuria.lootjournal.client.pickup.ExperiencePickup;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import dev.obscuria.lootjournal.client.pickup.ItemPickup;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public final class PickupComponent {
    private static final HashMap<Integer, PickupInstance> occupied = Maps.newHashMap();
    private static final List<PickupInstance> displayed = Lists.newArrayList();
    private static final Deque<IPickupEntry> queued = Queues.newArrayDeque();

    public static void render(GuiGraphics graphics) {
        Window window = Minecraft.m_91087_().m_91268_();
        graphics.m_280168_().m_85836_();
        LootJournal.CONFIG.anchor.transform(graphics, window);
        displayed.removeIf(instance -> {
            if (!instance.render(graphics)) {
                return false;
            }
            occupied.remove(instance.index);
            return true;
        });
        graphics.m_280168_().m_85849_();
        if (queued.isEmpty() || PickupComponent.isAllSlotsOccupied()) {
            return;
        }
        queued.removeIf(pickup -> {
            int index = PickupComponent.findFreeSlot();
            if (index <= -1) {
                return false;
            }
            PickupInstance instance = new PickupInstance((IPickupEntry)pickup, index);
            displayed.add(instance);
            occupied.put(index, instance);
            return true;
        });
    }

    public static void appendItem(int itemId, int playerId, int amount) {
        if (!LootJournal.CONFIG.itemEntryDisplay) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19879_() != playerId) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(itemId);
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity entity2 = (ItemEntity)entity;
        ItemStack stack = entity2.m_32055_().m_41777_();
        stack.m_41764_(amount);
        PickupComponent.appendItem(stack);
    }

    public static void appendItem(ItemStack stack) {
        if (!LootJournal.CONFIG.itemEntryDisplay) {
            return;
        }
        if (!LootJournal.isAllowed(stack)) {
            return;
        }
        boolean shouldAggregate = PickupComponent.shouldAggregate();
        if (shouldAggregate && !LootJournal.CONFIG.aggregatedEntryDisplay) {
            return;
        }
        PickupComponent.append(shouldAggregate ? new AggregatedPickup(stack) : new ItemPickup(stack));
    }

    public static void appendExperience(int amount) {
        if (!LootJournal.CONFIG.experienceEntryDisplay) {
            return;
        }
        PickupComponent.append(new ExperiencePickup(amount));
    }

    private static void append(IPickupEntry pickup) {
        if (PickupComponent.maybeMerge(pickup)) {
            return;
        }
        int index = PickupComponent.findFreeSlot();
        if (index > -1) {
            PickupInstance instance = new PickupInstance(pickup, index);
            displayed.add(instance);
            occupied.put(index, instance);
        } else if (PickupComponent.shouldEnqueue(pickup)) {
            queued.add(pickup);
        }
    }

    private static boolean maybeMerge(IPickupEntry pickup) {
        for (PickupInstance instance : displayed) {
            if (!instance.maybeMerge(pickup)) continue;
            return true;
        }
        for (IPickupEntry other : queued) {
            if (!other.maybeMerge(pickup)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldEnqueue(IPickupEntry pickup) {
        return pickup instanceof AggregatedPickup || queued.size() < LootJournal.CONFIG.queueCapacity;
    }

    private static int findFreeSlot() {
        for (int i = 0; i < LootJournal.CONFIG.displayCapacity; ++i) {
            if (occupied.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isAllSlotsOccupied() {
        return displayed.size() >= LootJournal.CONFIG.displayCapacity;
    }

    private static boolean shouldAggregate() {
        return PickupComponent.isAllSlotsOccupied() && queued.size() >= LootJournal.CONFIG.queueCapacity - 1;
    }

    private static final class PickupInstance {
        private static final long FADE_IN = 750L;
        private static final long FADE_OUT = 1500L;
        private final IPickupEntry pickup;
        private long startTime = -1L;
        private long lastTime;
        private double progress;
        private double delta;
        public int index;

        public PickupInstance(IPickupEntry pickup, int index) {
            this.pickup = pickup;
            this.index = index;
        }

        public boolean render(GuiGraphics graphics) {
            long currentTime = Util.m_137550_();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
                this.lastTime = currentTime;
            }
            this.delta = (double)(currentTime - this.lastTime) / 1000.0;
            this.lastTime = currentTime;
            long time = currentTime - this.startTime;
            if (!Minecraft.m_91087_().f_91066_.f_92062_) {
                int offset = LootJournal.CONFIG.anchor.getStep() * this.index;
                LootJournal.CONFIG.style.render(this.pickup, graphics, offset, this.progress, time);
            }
            this.updateProgress(time);
            return time > this.getDisplayTime();
        }

        public boolean maybeMerge(IPickupEntry other) {
            if (this.pickup.maybeMerge(other)) {
                this.startTime = Util.m_137550_();
                return true;
            }
            return this.pickup.maybeMerge(other);
        }

        private void updateProgress(long time) {
            if (time <= 750L) {
                this.progress = Math.min(this.progress + this.delta * 2.0, 1.0);
            }
            if (time >= this.getDisplayTime() - 1500L) {
                this.progress = Math.max(this.progress - this.delta, 0.0);
            }
        }

        private long getLifetime() {
            return 1000L * (long)LootJournal.CONFIG.lifetime;
        }

        private long getDisplayTime() {
            return 2250L + this.getLifetime();
        }
    }
}

