/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.compress.utils.Lists;

public final class AggregatedPickup
implements IPickupEntry {
    private final List<ItemStack> stacks = Lists.newArrayList();
    private int count;

    public AggregatedPickup(ItemStack stack) {
        this.stacks.add(stack);
        this.count = stack.m_41613_();
    }

    @Override
    public MutableComponent getDisplayName() {
        return (this.count <= 1 ? Component.m_237115_((String)"pickup.loot_journal.grouped_items_single") : Component.m_237110_((String)"pickup.loot_journal.grouped_items_multiple", (Object[])new Object[]{this.count})).m_130948_(LootJournal.CONFIG.aggregatedEntryStyle);
    }

    @Override
    public int getTotalAmount() {
        return 0;
    }

    @Override
    public void renderIcon(GuiGraphics graphics, long time) {
        if (this.stacks.isEmpty()) {
            return;
        }
        int interval = Math.max(200, 1000 - 50 * this.stacks.size());
        ItemStack stack = this.stacks.get((int)(time / (long)interval % (long)this.stacks.size()));
        graphics.m_280203_(stack, -8, -8);
    }

    @Override
    public boolean maybeMerge(IPickupEntry pickup) {
        if (!(pickup instanceof AggregatedPickup)) {
            return false;
        }
        AggregatedPickup other = (AggregatedPickup)pickup;
        this.stacks.addAll(other.stacks);
        this.count += other.count;
        return true;
    }

    @Override
    public boolean shouldDisplayTotalAmount() {
        return false;
    }
}

