/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.client.renderers;

import com.cicada.longwings.client.model.ButterflyModel;
import com.cicada.longwings.client.model.MothModel;
import com.cicada.longwings.entity.ButterflyEntity;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class ButterflyEntityRenderer<T extends ButterflyEntity>
extends MobRenderer<T, ButterflyModel<T>> {
    private static ResourceLocation TEXTURE = new ResourceLocation("longwings", "textures/entity/butterfly/monarch.png");
    private final ButterflyModel<T> modelA;
    private ButterflyModel<T> modelB;

    public ButterflyEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new ButterflyModel(context.m_174023_(ButterflyModel.LAYER_LOCATION)), 0.0f);
        this.modelA = new ButterflyModel(context.m_174023_(ButterflyModel.LAYER_LOCATION));
        this.modelB = new ButterflyModel(context.m_174023_(MothModel.LAYER_LOCATION));
    }

    public void render(T p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        if (p_115455_.m_20145_()) {
            return;
        }
        this.f_115290_ = this.modelA;
        ArrayList<ButterflyVariant> pool = ButterflyVariant.getAllVariantPool();
        int size = pool.size();
        ButterflyVariant variant = ButterflyVariant.ATLAS;
        EnumButterflyTraits.BodyType mothBody = EnumButterflyTraits.BodyType.MOTH;
        String stringId = ((ButterflyEntity)((Object)p_115455_)).getVariant();
        for (int a = 0; a < size; ++a) {
            boolean tool2;
            variant = pool.get(a);
            boolean tool = variant.getButterflyStringId().matches(stringId);
            if (!tool) continue;
            boolean bl = tool2 = variant.bodyType() == mothBody;
            if (!tool2) continue;
            this.f_115290_ = this.modelB;
        }
        super.m_7392_(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }

    protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        return RenderType.m_110452_((ResourceLocation)this.getTextureLocation((ButterflyEntity)((Object)p_115322_)));
    }

    public static boolean hasCustomTexture(ResourceLocation resourceLocation) {
        return Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).isPresent();
    }

    public ResourceLocation getTextureLocation(ButterflyEntity p_114482_) {
        ResourceLocation customTexture = new ResourceLocation("longwings", "textures/entity/butterfly/" + p_114482_.getVariant() + ".png");
        ResourceLocation defaultTexture = new ResourceLocation("longwings", "textures/entity/butterfly/painted_lady.png");
        return ButterflyEntityRenderer.hasCustomTexture(customTexture) ? customTexture : defaultTexture;
    }

    public static class MothEntityRenderer<T extends ButterflyEntity.MothEntity>
    extends MobRenderer<T, ButterflyModel<T>> {
        private static ResourceLocation TEXTURE = new ResourceLocation("longwings", "textures/entity/butterfly/monarch.png");
        private final ButterflyModel<T> modelA;
        private ButterflyModel<T> modelB;

        public MothEntityRenderer(EntityRendererProvider.Context context) {
            super(context, new ButterflyModel(context.m_174023_(ButterflyModel.LAYER_LOCATION)), 0.0f);
            this.modelA = new ButterflyModel(context.m_174023_(ButterflyModel.LAYER_LOCATION));
            this.modelB = new ButterflyModel(context.m_174023_(MothModel.LAYER_LOCATION));
        }

        public void render(T p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
            if (p_115455_.m_20145_()) {
                return;
            }
            this.f_115290_ = this.modelA;
            ArrayList<ButterflyVariant> butterflyVariants = ButterflyVariant.getAllVariantPool();
            EnumButterflyTraits.BodyType moth = EnumButterflyTraits.BodyType.MOTH;
            for (int b = 0; b < butterflyVariants.size(); ++b) {
                if (!butterflyVariants.get(b).getButterflyStringId().matches(((ButterflyEntity)((Object)p_115455_)).getVariant()) || butterflyVariants.get(b).bodyType() != moth) continue;
                this.f_115290_ = this.modelB;
            }
            super.m_7392_(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        }

        protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
            return RenderType.m_110452_((ResourceLocation)this.getTextureLocation((ButterflyEntity.MothEntity)((Object)p_115322_)));
        }

        public ResourceLocation getTextureLocation(ButterflyEntity.MothEntity p_114482_) {
            ResourceLocation customTexture = new ResourceLocation("longwings", "textures/entity/moth/" + p_114482_.getVariant() + ".png");
            ResourceLocation defaultTexture = new ResourceLocation("longwings", "textures/entity/moth/small_white_wave.png");
            return ButterflyEntityRenderer.hasCustomTexture(customTexture) ? customTexture : defaultTexture;
        }
    }
}

