/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.littletractor;

import com.dragn0007.littletractor.Animation;
import com.dragn0007.littletractor.Tractor;
import com.dragn0007.littletractor.TractorRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TractorModel
extends EntityModel<Tractor> {
    private final ModelPart body;
    private final ModelPart frontWheels;
    private final ModelPart backWheels;
    private final ModelPart tiller;

    public TractorModel(ModelPart root) {
        this.body = root.m_171324_("Body");
        this.frontWheels = root.m_171324_("FrontWheels");
        this.backWheels = root.m_171324_("Backwheels");
        this.tiller = root.m_171324_("Tiller");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-17.9167f, 20.4909f, -30.5492f, 30.0f, 3.0f, 55.0f, new CubeDeformation(0.0f)).m_171514_(0, 148).m_171488_(-13.9167f, 9.4909f, -0.5492f, 22.0f, 4.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(0, 127).m_171488_(-12.9167f, -3.5091f, 15.3508f, 20.0f, 17.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(176, 70).m_171488_(10.0833f, -0.6332f, 3.2931f, 4.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(64, 148).m_171488_(-19.9167f, -0.6332f, 3.2931f, 4.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(159, 167).m_171488_(-19.9167f, 9.3668f, -22.7069f, 34.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(115, 0).m_171488_(-15.9167f, -17.4091f, -3.5492f, 26.0f, 2.0f, 29.0f, new CubeDeformation(0.0f)).m_171514_(104, 58).m_171488_(-13.9167f, 3.4909f, -28.5492f, 22.0f, 17.0f, 28.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-13.9167f, -15.5091f, 19.4508f, 22.0f, 36.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(8.0833f, -15.5091f, -1.5492f, 1.0f, 15.0f, 23.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-13.9167f, -15.5091f, -0.5492f, 22.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(-14.9167f, -15.5091f, -1.5492f, 1.0f, 15.0f, 23.0f, new CubeDeformation(0.0f)).m_171514_(52, 79).m_171488_(-15.9167f, -0.5091f, -26.5492f, 2.0f, 21.0f, 48.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(8.0833f, -0.5091f, -26.5492f, 2.0f, 21.0f, 48.0f, new CubeDeformation(0.0f)).m_171514_(158, 216).m_171488_(8.1833f, -22.5091f, -0.7492f, 4.0f, 26.0f, 4.0f, new CubeDeformation(-0.005f)).m_171514_(44, 40).m_171488_(9.1833f, -33.5091f, 0.2508f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(9.1833f, 3.4909f, 0.2508f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(123, 121).m_171488_(-13.9167f, -1.5091f, -29.5492f, 22.0f, 5.0f, 29.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.9167f, (float)-5.4909f, (float)2.5492f));
        PartDefinition cube_r1 = Body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(24, 96).m_171488_(13.0f, -2.5f, -16.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 96).m_171488_(-17.0f, -2.5f, -16.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.9167f, (float)11.9909f, (float)25.4508f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = Body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 172).m_171488_(-17.0f, -2.5f, -16.0f, 34.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.9167f, (float)21.9909f, (float)-3.5492f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition FrontWheels = partdefinition.m_171599_("FrontWheels", CubeListBuilder.m_171558_().m_171514_(215, 82).m_171488_(13.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(-0.005f)).m_171514_(196, 121).m_171488_(-19.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(-0.005f)).m_171514_(115, 41).m_171488_(-20.0f, -2.5f, -2.5f, 40.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)-15.5f));
        PartDefinition cube_r3 = FrontWheels.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(106, 210).m_171488_(-2.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(104, 58).m_171488_(-34.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)15.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = FrontWheels.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(132, 210).m_171488_(-2.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(-0.005f)).m_171514_(196, 0).m_171488_(-34.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(-0.005f)), PartPose.m_171423_((float)15.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = FrontWheels.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(80, 210).m_171488_(-2.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(115, 0).m_171488_(-34.0f, -8.5f, -3.5f, 6.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)15.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition Backwheels = partdefinition.m_171599_("Backwheels", CubeListBuilder.m_171558_().m_171514_(195, 178).m_171488_(13.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(-0.005f)).m_171514_(52, 58).m_171488_(-22.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(-0.005f)).m_171514_(115, 31).m_171488_(-23.0f, -2.5f, -2.5f, 46.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)11.5f));
        PartDefinition cube_r6 = Backwheels.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(40, 199).m_171488_(-2.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(-0.005f)).m_171514_(115, 172).m_171488_(-37.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(-0.005f)), PartPose.m_171423_((float)15.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = Backwheels.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(155, 178).m_171488_(-7.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(198, 44).m_171488_(28.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-15.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = Backwheels.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(75, 172).m_171488_(-7.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 183).m_171488_(28.0f, -13.5f, -5.5f, 9.0f, 27.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-15.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Tiller = partdefinition.m_171599_("Tiller", CubeListBuilder.m_171558_().m_171514_(104, 103).m_171488_(-24.0f, 1.8333f, 10.25f, 48.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(154, 159).m_171488_(-23.0f, 4.8333f, 11.25f, 46.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(154, 159).m_171488_(-23.0f, 4.8333f, 23.25f, 46.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(154, 159).m_171488_(-23.0f, 4.8333f, 20.25f, 46.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(154, 159).m_171488_(-23.0f, 4.8333f, 14.25f, 46.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(84, 155).m_171488_(-14.0f, -0.1667f, 0.25f, 28.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.1667f, (float)18.75f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontWheels.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.backWheels.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tiller.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void prepareMobModel(Tractor tractor, float p_102615_, float p_102616_, float partialTick) {
        Animation.animate(this.body, TractorRenderer.BODY_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        Animation.animate(this.frontWheels, TractorRenderer.FRONT_WHEEL_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        Animation.animate(this.backWheels, TractorRenderer.BACK_WHEEL_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        Animation.animate(this.tiller, TractorRenderer.TILLER_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
    }

    public void setupAnim(Tractor tractor, float partialTick, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        tractor.updateLastDrivePartialTick(partialTick);
        Animation.animate(this.body, TractorRenderer.BODY_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        Animation.animate(this.frontWheels, TractorRenderer.FRONT_WHEEL_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        Animation.animate(this.backWheels, TractorRenderer.BACK_WHEEL_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        Animation.animate(this.tiller, TractorRenderer.TILLER_ANIMATION, tractor.driveTick, tractor.lastDrivePartialTick, tractor.forwardMotion);
        this.frontWheels.f_104204_ = tractor.getFrontWheelRotation(partialTick);
    }
}

