/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.util.codec.CustomizationCodecs;

public class BlockFamily {
    public static final Codec<BlockFamily> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter($ -> true), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256747_).listOf().optionalFieldOf("blocks", List.of()).forGetter($ -> $.blockHolders().stream().map(Holder.Reference::m_205785_).toList()), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256913_).listOf().optionalFieldOf("items", List.of()).forGetter($ -> $.itemHolders().stream().map(Holder.Reference::m_205785_).toList()), (App)CustomizationCodecs.compactList(ResourceKey.m_195966_((ResourceKey)Registries.f_256913_)).optionalFieldOf("exchange_inputs_in_viewer", List.of()).forGetter($ -> $.exchangeInputsInViewer().stream().map(Holder.Reference::m_205785_).toList()), (App)Codec.BOOL.optionalFieldOf("stonecutter_exchange", (Object)false).forGetter(BlockFamily::stonecutterExchange), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256913_).optionalFieldOf("stonecutter_from").forGetter($ -> $.stonecutterSource().map(Holder.Reference::m_205785_)), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("stonecutter_from_multiplier", (Object)1).forGetter(BlockFamily::stonecutterSourceMultiplier), (App)SwitchAttrs.CODEC.optionalFieldOf("switch", (Object)SwitchAttrs.DISABLED).forGetter(BlockFamily::switchAttrs)).apply((Applicative)instance, BlockFamily::new));
    private final List<Holder.Reference<Block>> blocks;
    private final List<Holder.Reference<Item>> items;
    private final List<Holder.Reference<Item>> exchangeInputsInViewer;
    private final boolean stonecutterExchange;
    private final Optional<Holder.Reference<Item>> stonecutterFrom;
    private final int stonecutterFromMultiplier;
    private final SwitchAttrs switchAttrs;
    private Ingredient ingredient;
    private Ingredient ingredientInViewer;

    public BlockFamily(boolean strict, List<ResourceKey<Block>> blocks, List<ResourceKey<Item>> items, List<ResourceKey<Item>> exchangeInputsInViewer, boolean stonecutterExchange, Optional<ResourceKey<Item>> stonecutterFrom, int stonecutterFromMultiplier, SwitchAttrs switchAttrs) {
        this.blocks = blocks.stream().map($ -> {
            Optional holder = BuiltInRegistries.f_256975_.m_203636_($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Block %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get).toList();
        this.items = Stream.concat(this.blocks.stream().map(Holder::m_203334_).map(ItemLike::m_5456_).filter(Predicate.not(Items.f_41852_::equals)).mapToInt(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7447_(arg_0)).distinct().mapToObj(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_203300_(arg_0)).map(Optional::orElseThrow), items.stream().map($ -> {
            Optional holder = BuiltInRegistries.f_257033_.m_203636_($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Item %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get)).toList();
        this.exchangeInputsInViewer = exchangeInputsInViewer.stream().map($ -> {
            Optional holder = BuiltInRegistries.f_257033_.m_203636_($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Item %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get).toList();
        this.stonecutterExchange = stonecutterExchange;
        this.stonecutterFrom = stonecutterFrom.map($ -> {
            Optional holder = BuiltInRegistries.f_257033_.m_203636_($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Item %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get);
        this.stonecutterFromMultiplier = stonecutterFromMultiplier;
        this.switchAttrs = switchAttrs;
        Preconditions.checkArgument((!blocks.isEmpty() || !items.isEmpty() ? 1 : 0) != 0, (Object)"No entries found in family");
        Preconditions.checkArgument((this.blocks().distinct().count() == (long)this.blocks.size() ? 1 : 0) != 0, (String)"Duplicate blocks found in family %s", (Object)this);
        Preconditions.checkArgument((this.items().distinct().count() == (long)this.items.size() ? 1 : 0) != 0, (String)"Duplicate items found in family %s", (Object)this);
    }

    public List<Holder.Reference<Block>> blockHolders() {
        return this.blocks;
    }

    public List<Holder.Reference<Item>> itemHolders() {
        return this.items;
    }

    public List<Holder.Reference<Item>> exchangeInputsInViewer() {
        return this.exchangeInputsInViewer;
    }

    public Stream<Block> blocks() {
        return this.blocks.stream().map(Holder::m_203334_);
    }

    public Stream<Item> items() {
        return this.items.stream().map(Holder::m_203334_);
    }

    public boolean stonecutterExchange() {
        return this.stonecutterExchange;
    }

    public Optional<Holder.Reference<Item>> stonecutterSource() {
        return this.stonecutterFrom;
    }

    public int stonecutterSourceMultiplier() {
        return this.stonecutterFromMultiplier;
    }

    public Ingredient stonecutterSourceIngredient() {
        return this.stonecutterFrom.map(holder -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)holder.m_203334_()})).orElse(Ingredient.f_43901_);
    }

    public SwitchAttrs switchAttrs() {
        return this.switchAttrs;
    }

    protected Ingredient toIngredient(List<? extends Holder<Item>> items) {
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])items.stream().map(Holder::m_203334_).filter(item -> BlockFamilies.getConvertRatio(item) >= 1.0f).toArray(ItemLike[]::new)));
    }

    public Ingredient ingredient() {
        if (this.ingredient == null) {
            this.ingredient = this.toIngredient(this.items);
        }
        return this.ingredient;
    }

    public Ingredient ingredientInViewer() {
        if (this.ingredientInViewer == null) {
            this.ingredientInViewer = this.exchangeInputsInViewer.isEmpty() ? this.ingredient() : this.toIngredient(this.exchangeInputsInViewer);
        }
        return this.ingredientInViewer;
    }

    public boolean contains(Item item) {
        return this.items.stream().anyMatch(h -> ((Item)h.m_203334_()).m_5456_() == item);
    }

    public String toString() {
        return "BlockFamily{blocks=" + this.blocks + ", items=" + this.items + ", stonecutterFrom=" + this.stonecutterFrom + "}";
    }

    public record SwitchAttrs(boolean enabled, boolean cascading, boolean creativeOnly) {
        public static final Codec<SwitchAttrs> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(SwitchAttrs::enabled), (App)Codec.BOOL.optionalFieldOf("cascading", (Object)false).forGetter(SwitchAttrs::cascading), (App)Codec.BOOL.optionalFieldOf("creative_only", (Object)false).forGetter(SwitchAttrs::creativeOnly)).apply((Applicative)instance, SwitchAttrs::create));
        public static final SwitchAttrs DISABLED = new SwitchAttrs(false, false, false);
        private static final Interner<SwitchAttrs> INTERNER = Interners.newStrongInterner();

        public static SwitchAttrs create(boolean enabled, boolean cascading, boolean creativeOnly) {
            if (!enabled) {
                Preconditions.checkArgument((!cascading ? 1 : 0) != 0, (Object)"Cascading switch must be disabled if switch is disabled");
                Preconditions.checkArgument((!creativeOnly ? 1 : 0) != 0, (Object)"Creative only switch must be disabled if switch is disabled");
                return DISABLED;
            }
            return (SwitchAttrs)INTERNER.intern((Object)new SwitchAttrs(true, cascading, creativeOnly));
        }
    }
}

