/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item.tool;

import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.mesdag.geckojs.item.AnimatableItemRenderer;
import org.mesdag.geckojs.item.tool.AnimatableTiredItemBuilder;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatablePickaxeItem
extends PickaxeItem
implements GeoItem {
    private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Builder pickaxeItemBuilder;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private boolean modified = false;

    public AnimatablePickaxeItem(Builder pickaxeItemBuilder) {
        super((Tier)pickaxeItemBuilder.toolTier, (int)pickaxeItemBuilder.attackDamageBaseline, pickaxeItemBuilder.speedBaseline, pickaxeItemBuilder.createItemProperties());
        this.pickaxeItemBuilder = pickaxeItemBuilder;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.pickaxeItemBuilder.usingAnimationCallback != null) {
                this.pickaxeItemBuilder.usingAnimationCallback.call(this, serverLevel, (ServerPlayer)player, hand);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.pickaxeItemBuilder.finishUsingAnimationCallback != null) {
                this.pickaxeItemBuilder.finishUsingAnimationCallback.call(this, serverLevel, livingEntity);
            }
        }
        return super.m_5922_(itemStack, level, livingEntity);
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int tick) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.pickaxeItemBuilder.releaseUsingAnimationCallback != null) {
                this.pickaxeItemBuilder.releaseUsingAnimationCallback.call(this, serverLevel, livingEntity, tick);
            }
        }
        super.m_5551_(itemStack, level, livingEntity, tick);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            if (!this.modified) {
                this.modified = true;
                Multimap defaultModifiers = super.m_7167_(equipmentSlot);
                this.pickaxeItemBuilder.attributes.forEach((r, m) -> defaultModifiers.put((Object)((Attribute)RegistryInfo.ATTRIBUTE.getValue(r)), m));
                this.attributeModifiers = defaultModifiers;
            }
            return this.attributeModifiers;
        }
        return super.m_7167_(equipmentSlot);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatableItemRenderer<AnimatablePickaxeItem> renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    AnimatableItemRenderer itemRenderer = new AnimatableItemRenderer(AnimatablePickaxeItem.this.pickaxeItemBuilder.itemModel);
                    if (AnimatablePickaxeItem.this.pickaxeItemBuilder.useEntityGuiLighting) {
                        itemRenderer.useAlternateGuiLighting();
                    }
                    this.renderer = itemRenderer;
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        this.pickaxeItemBuilder.controllers.forEach(controller -> registrar.add(new AnimationController[]{controller.build(this)}));
        this.pickaxeItemBuilder.animations.forEach(animation -> {
            AnimationController[] animationControllerArray = new AnimationController[1];
            animationControllerArray[0] = new AnimationController((GeoAnimatable)this, animation::create);
            registrar.add(animationControllerArray);
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }

    public static class Builder
    extends AnimatableTiredItemBuilder<AnimatablePickaxeItem> {
        public Builder(ResourceLocation id) {
            super(id, 1.0f, -2.8f);
        }

        public AnimatablePickaxeItem createObject() {
            return new AnimatablePickaxeItem(this);
        }
    }
}

