/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item.tool;

import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.mesdag.geckojs.item.AnimatableItemRenderer;
import org.mesdag.geckojs.item.tool.AnimatableTiredItemBuilder;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatableAxeItem
extends AxeItem
implements GeoItem {
    private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Builder axeItemBuilder;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private boolean modified = false;

    public AnimatableAxeItem(Builder axeItemBuilder) {
        super((Tier)axeItemBuilder.toolTier, axeItemBuilder.attackDamageBaseline, axeItemBuilder.speedBaseline, axeItemBuilder.createItemProperties());
        this.axeItemBuilder = axeItemBuilder;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.axeItemBuilder.usingAnimationCallback != null) {
                this.axeItemBuilder.usingAnimationCallback.call(this, serverLevel, (ServerPlayer)player, hand);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.axeItemBuilder.finishUsingAnimationCallback != null) {
                this.axeItemBuilder.finishUsingAnimationCallback.call(this, serverLevel, livingEntity);
            }
        }
        return super.m_5922_(itemStack, level, livingEntity);
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int tick) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.axeItemBuilder.releaseUsingAnimationCallback != null) {
                this.axeItemBuilder.releaseUsingAnimationCallback.call(this, serverLevel, livingEntity, tick);
            }
        }
        super.m_5551_(itemStack, level, livingEntity, tick);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            if (!this.modified) {
                this.modified = true;
                Multimap defaultModifiers = super.m_7167_(equipmentSlot);
                this.axeItemBuilder.attributes.forEach((r, m) -> defaultModifiers.put((Object)((Attribute)RegistryInfo.ATTRIBUTE.getValue(r)), m));
                this.attributeModifiers = defaultModifiers;
            }
            return this.attributeModifiers;
        }
        return super.m_7167_(equipmentSlot);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatableItemRenderer<AnimatableAxeItem> renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    AnimatableItemRenderer itemRenderer = new AnimatableItemRenderer(AnimatableAxeItem.this.axeItemBuilder.itemModel);
                    if (AnimatableAxeItem.this.axeItemBuilder.useEntityGuiLighting) {
                        itemRenderer.useAlternateGuiLighting();
                    }
                    this.renderer = itemRenderer;
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        this.axeItemBuilder.controllers.forEach(controller -> registrar.add(new AnimationController[]{controller.build(this)}));
        this.axeItemBuilder.animations.forEach(animation -> {
            AnimationController[] animationControllerArray = new AnimationController[1];
            animationControllerArray[0] = new AnimationController((GeoAnimatable)this, animation::create);
            registrar.add(animationControllerArray);
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }

    public static class Builder
    extends AnimatableTiredItemBuilder<AnimatableAxeItem> {
        public Builder(ResourceLocation id) {
            super(id, 6.0f, -3.1f);
        }

        public AnimatableAxeItem createObject() {
            return new AnimatableAxeItem(this);
        }
    }
}

