/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item.armor;

import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.mesdag.geckojs.AnimationControllerBuilder;
import org.mesdag.geckojs.item.AnimatableItemRenderer;
import org.mesdag.geckojs.item.armor.AnimatableArmorBuilder;
import org.mesdag.geckojs.item.armor.AnimatableArmorRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatableArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimatableArmorBuilder armorBuilder;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private boolean modified = false;

    public AnimatableArmorItem(AnimatableArmorBuilder armorBuilder) {
        super((ArmorMaterial)armorBuilder.armorTier, armorBuilder.armorType, armorBuilder.createItemProperties());
        this.armorBuilder = armorBuilder;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatableArmorRenderer armorRenderer;
            private AnimatableItemRenderer<AnimatableArmorItem> itemRenderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.armorRenderer == null) {
                    this.armorRenderer = new AnimatableArmorRenderer(AnimatableArmorItem.this.armorBuilder.armorModel, AnimatableArmorItem.this.armorBuilder.boneVisibilityCallback);
                }
                this.armorRenderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.armorRenderer;
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (AnimatableArmorItem.this.armorBuilder.useGeoModel) {
                    if (this.itemRenderer == null) {
                        this.itemRenderer = new AnimatableItemRenderer<AnimatableArmorItem>(AnimatableArmorItem.this.armorBuilder.armorModel);
                    }
                    return this.itemRenderer;
                }
                return super.getCustomRenderer();
            }
        });
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        if (equipmentSlot == this.f_265916_.m_266308_()) {
            if (!this.modified) {
                this.modified = true;
                Multimap defaultModifiers = super.m_7167_(equipmentSlot);
                this.armorBuilder.attributes.forEach((r, m) -> defaultModifiers.put((Object)((Attribute)RegistryInfo.ATTRIBUTE.getValue(r)), m));
                this.attributeModifiers = defaultModifiers;
            }
            return this.attributeModifiers;
        }
        return super.m_7167_(equipmentSlot);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        this.armorBuilder.controllers.forEach((Consumer<AnimationControllerBuilder<AnimatableArmorItem>>)((Consumer<AnimationControllerBuilder>)controller -> registrar.add(new AnimationController[]{controller.build(this)})));
        this.armorBuilder.animations.forEach(animation -> {
            AnimationController[] animationControllerArray = new AnimationController[1];
            animationControllerArray[0] = new AnimationController((GeoAnimatable)this, animation::create);
            registrar.add(animationControllerArray);
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }
}

