/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.block;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.mesdag.geckojs.ExtendedGeoModel;
import org.mesdag.geckojs.block.AnimatableBlockBuilder;
import org.mesdag.geckojs.block.AnimatableBlockItem;

public class AnimatableBlockItemBuilder
extends ItemBuilder {
    private final AnimatableBlockBuilder blockBuilder;
    public final ExtendedGeoModel<AnimatableBlockItem> itemModel = new ExtendedGeoModel();
    public boolean hasModel = false;
    public transient boolean useEntityGuiLighting = false;

    public AnimatableBlockItemBuilder(ResourceLocation id, AnimatableBlockBuilder blockBuilder) {
        super(id);
        this.blockBuilder = blockBuilder;
    }

    public AnimatableBlockItemBuilder geoModel(Consumer<ExtendedGeoModel.Builder<AnimatableBlockItem>> consumer) {
        consumer.accept(this.itemModel.builder);
        this.hasModel = true;
        return this;
    }

    public AnimatableBlockItemBuilder defaultGeoModel() {
        this.itemModel.builder.setSimpleModel(new ResourceLocation(this.id.m_135827_(), "geo/block/" + this.id.m_135815_() + ".geo.json"));
        this.itemModel.builder.setSimpleTexture(new ResourceLocation(this.id.m_135827_(), "textures/block/" + this.id.m_135815_() + ".png"));
        this.itemModel.builder.setSimpleAnimation(new ResourceLocation(this.id.m_135827_(), "animations/block/" + this.id.m_135815_() + ".animation.json"));
        this.hasModel = true;
        return this;
    }

    public AnimatableBlockItemBuilder useEntityGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    public Item createObject() {
        return new AnimatableBlockItem((Block)this.blockBuilder.get(), this.createItemProperties(), this);
    }

    public String getTranslationKeyGroup() {
        return "block";
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.modelJson == null) {
            generator.itemModel(this.id, model -> model.parent(this.parentModel.isEmpty() ? "geckojs:item/item" : this.parentModel));
        } else {
            generator.json(AssetJsonGenerator.asItemModelLocation((ResourceLocation)this.id), (JsonElement)this.modelJson);
        }
    }
}

