/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityBuilder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityInfo;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.mesdag.geckojs.ExtendedGeoModel;
import org.mesdag.geckojs.GeckoJS;
import org.mesdag.geckojs.block.AnimatableBlock;
import org.mesdag.geckojs.block.AnimatableBlockItemBuilder;
import org.mesdag.geckojs.block.entity.AnimatableBlockEntity;
import org.mesdag.geckojs.block.entity.AnimatableBlockEntityInfo;

public class AnimatableBlockBuilder
extends BlockBuilder {
    public final transient AnimatableBlockEntityInfo blockEntityInfo = new AnimatableBlockEntityInfo(this);
    private final ExtendedGeoModel<AnimatableBlockEntity> blockModel = new ExtendedGeoModel();
    private transient AnimatableBlockItemBuilder itemBuilder;

    public AnimatableBlockBuilder(ResourceLocation id) {
        super(id);
        this.itemBuilder = new AnimatableBlockItemBuilder(id, this);
        this.opaque = false;
    }

    @Info(value="Creates a animatable Block Entity for this block")
    public AnimatableBlockBuilder animatableBlockEntity(Consumer<AnimatableBlockEntityInfo> consumer) {
        consumer.accept(this.blockEntityInfo);
        return this;
    }

    public AnimatableBlockBuilder geoModel(Consumer<ExtendedGeoModel.Builder<AnimatableBlockEntity>> consumer) {
        consumer.accept(this.blockModel.builder);
        return this;
    }

    public AnimatableBlockBuilder defaultGeoModel() {
        this.blockModel.builder.setSimpleModel(new ResourceLocation(this.id.m_135827_(), "geo/block/" + this.id.m_135815_() + ".geo.json"));
        this.blockModel.builder.setSimpleTexture(new ResourceLocation(this.id.m_135827_(), "textures/block/" + this.id.m_135815_() + ".png"));
        this.blockModel.builder.setSimpleAnimation(new ResourceLocation(this.id.m_135827_(), "animations/block/" + this.id.m_135815_() + ".animation.json"));
        return this;
    }

    public AnimatableBlockBuilder animatableItem(Consumer<AnimatableBlockItemBuilder> consumer) {
        consumer.accept(this.itemBuilder);
        return this;
    }

    public BlockBuilder noItem() {
        this.itemBuilder = null;
        return super.noItem();
    }

    public void createAdditionalObjects() {
        if (this.itemBuilder != null) {
            RegistryInfo.ITEM.addBuilder((BuilderBase)(this.itemBuilder.hasModel ? this.itemBuilder : this.itemBuilder.defaultGeoModel()));
        }
        RegistryInfo.BLOCK_ENTITY_TYPE.addBuilder((BuilderBase)new BlockEntityBuilder(this.id, (BlockEntityInfo)this.blockEntityInfo));
        GeckoJS.REGISTERED_BLOCK.put(this.id, this.blockModel);
    }

    public Block createObject() {
        return new AnimatableBlock(this);
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.blockState(this.id, x$0 -> this.generateBlockStateJson((VariantBlockStateGenerator)x$0));
        JsonObject blockModelJson = JsonUtils.GSON.toJsonTree(Map.of("parent", "block/block", "textures", Map.of("particle", this.id.m_135827_() + ":block/" + this.id.m_135815_()))).getAsJsonObject();
        generator.json(new ResourceLocation(this.id.m_135827_(), "models/block/" + this.id.m_135815_()), (JsonElement)blockModelJson);
    }

    @HideFromJS
    public BlockBuilder blockEntity(Consumer<BlockEntityInfo> callback) {
        return super.blockEntity(callback);
    }

    @HideFromJS
    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        return super.item(i);
    }

    @HideFromJS
    public BlockBuilder renderType(String l) {
        return super.renderType(l);
    }

    @HideFromJS
    public BlockBuilder texture(String id, String tex) {
        return super.texture(id, tex);
    }

    @HideFromJS
    public BlockBuilder textureAll(String tex) {
        return super.textureAll(tex);
    }

    @HideFromJS
    public BlockBuilder textureSide(Direction direction, String tex) {
        return super.textureSide(direction, tex);
    }

    @HideFromJS
    public BlockBuilder model(String m) {
        return super.model(m);
    }

    @HideFromJS
    public BlockBuilder transparent(boolean b) {
        return super.transparent(b);
    }

    @HideFromJS
    public BlockBuilder defaultCutout() {
        return super.defaultCutout();
    }

    @HideFromJS
    public BlockBuilder defaultTranslucent() {
        return super.defaultTranslucent();
    }
}

