/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs;

import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;

public class ExtendedGeoModel<T extends GeoAnimatable>
extends GeoModel<T> {
    static final ResourceLocation EMPTY = new ResourceLocation("geckojs", "empty");
    public final Builder<T> builder = new Builder();

    public ResourceLocation getModelResource(T animatable) {
        if (this.builder.simpleModel != null) {
            return this.builder.simpleModel;
        }
        if (this.builder.model == null) {
            return EMPTY;
        }
        return this.builder.model.create(animatable);
    }

    public ResourceLocation getTextureResource(T animatable) {
        if (this.builder.simpleTexture != null) {
            return this.builder.simpleTexture;
        }
        if (this.builder.texture == null) {
            return EMPTY;
        }
        return this.builder.texture.create(animatable);
    }

    public ResourceLocation getAnimationResource(T animatable) {
        if (this.builder.simpleAnimation != null) {
            return this.builder.simpleAnimation;
        }
        if (this.builder.animation == null) {
            return EMPTY;
        }
        return this.builder.animation.create(animatable);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureResource(animatable));
    }

    public static class Builder<T extends GeoAnimatable> {
        ResourceCallback<T> model;
        ResourceCallback<T> texture;
        ResourceCallback<T> animation;
        ResourceLocation simpleModel;
        ResourceLocation simpleTexture;
        ResourceLocation simpleAnimation;
        public float scaleWidth = 1.0f;
        public float scaleHeight = 1.0f;
        public boolean autoGlowing = false;

        @Info(value="This method should return the ResourceLocation path to your .geo.json model file for this animatable")
        public void setModel(ResourceCallback<T> model) {
            this.model = model;
        }

        @Info(value="The ResourceLocation path to your .geo.json model file for this animatable")
        public void setSimpleModel(ResourceLocation model) {
            this.simpleModel = model;
        }

        @Info(value="This method should return the ResourceLocation path to your .png texture file for this animatable")
        public void setTexture(ResourceCallback<T> texture) {
            this.texture = texture;
        }

        @Info(value="The ResourceLocation path to your .png texture file for this animatable")
        public void setSimpleTexture(ResourceLocation texture) {
            this.simpleTexture = texture;
        }

        @Info(value="This method should return the ResourceLocation path to your .animation.json animation file for this animatable")
        public void setAnimation(ResourceCallback<T> animation) {
            this.animation = animation;
        }

        @Info(value="The ResourceLocation path to your .animation.json animation file for this animatable")
        public void setSimpleAnimation(ResourceLocation animation) {
            this.simpleAnimation = animation;
        }

        public void setScale(float scale) {
            this.scaleWidth = scale;
            this.scaleHeight = scale;
        }
    }

    @FunctionalInterface
    public static interface ResourceCallback<T extends GeoAnimatable> {
        public ResourceLocation create(T var1);
    }
}

