/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.item;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TidalHelmetItem
extends ArmorItem {
    public static final ResourceLocation TEXTURE = new ResourceLocation("etcetera", "textures/models/armor/tidal_layer_1.png");
    public static final ResourceLocation ACTIVATED_TEXTURE = new ResourceLocation("etcetera", "textures/models/armor/active_tidal_layer_1.png");

    public TidalHelmetItem(ArmorMaterial p_40386_, ArmorItem.Type p_266831_, Item.Properties p_40388_) {
        super(p_40386_, p_266831_, p_40388_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ResourceLocation texture = livingEntity.m_204029_(FluidTags.f_13131_) && livingEntity.m_21023_(MobEffects.f_19592_) ? ACTIVATED_TEXTURE : TEXTURE;
            return texture.toString();
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }
}

