/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ninni.etcetera.client.model.CottonArmorModel;
import com.ninni.etcetera.registry.EtceteraEntityModelLayers;
import com.ninni.etcetera.registry.EtceteraSoundEvents;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SweaterItem
extends ArmorItem
implements Equipable {
    private static final Material material = new Material();
    private static final BiFunction<String, String, ResourceLocation> BI_FUNCTION = (s, s2) -> new ResourceLocation("etcetera", "textures/models/armor/cotton_" + s + "_" + s2 + ".png");
    boolean sweater;
    public static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource pointer, ItemStack stack) {
            return ArmorItem.m_40398_((BlockSource)pointer, (ItemStack)stack) ? stack : super.m_7498_(pointer, stack);
        }
    };

    public SweaterItem(Item.Properties properties, boolean sweater) {
        super((ArmorMaterial)material, sweater ? ArmorItem.Type.CHESTPLATE : ArmorItem.Type.HELMET, properties);
        this.sweater = sweater;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        return ImmutableMultimap.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return new CottonArmorModel(Minecraft.m_91087_().m_167973_().m_171103_(EtceteraEntityModelLayers.PLAYER_COTTON));
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String s) {
        String name = BuiltInRegistries.f_257033_.m_7981_((Object)this).m_135815_();
        String type = name.contains("sweater") || name.contains("robe") ? "sweater" : "hat";
        String traderType = name.contains("hood") ? "hood" : "robe";
        String removal = name.replace("cotton_", "").replace("_" + (name.contains("trader") ? traderType : type), "");
        return BI_FUNCTION.apply(type, removal).toString();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        return this.m_269277_((Item)this, world, user, hand);
    }

    public EquipmentSlot m_40402_() {
        return this.sweater ? EquipmentSlot.CHEST : EquipmentSlot.HEAD;
    }

    public boolean m_6832_(ItemStack p_40392_, ItemStack p_40393_) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    private static class Material
    implements ArmorMaterial {
        private Material() {
        }

        public int m_266425_(ArmorItem.Type p_266807_) {
            return 0;
        }

        public int m_7366_(ArmorItem.Type p_267168_) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return (SoundEvent)EtceteraSoundEvents.ITEM_ARMOR_EQUIP_COTTON.get();
        }

        public Ingredient m_6230_() {
            return Ingredient.m_151265_();
        }

        public String m_6082_() {
            return "cotton";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

