/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.item;

import com.ninni.etcetera.registry.EtceteraSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;

public class HandbellItem
extends Item {
    public HandbellItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        List hearingEntities = world.m_45976_(LivingEntity.class, new AABB(player.m_20183_()).m_82400_(48.0));
        if (!world.f_46443_) {
            HandbellItem.applyGlowToFriends(player.m_20183_(), hearingEntities, player);
        } else {
            HandbellItem.applyParticlesTooFriends(world, player.m_20183_(), hearingEntities, player);
        }
        world.m_5594_(player, player.m_20183_(), (SoundEvent)EtceteraSoundEvents.ITEM_HANDBELL_RING.get(), SoundSource.PLAYERS, 0.3f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    private static void applyGlowToFriends(BlockPos pos, List<LivingEntity> hearingEntities, Player player) {
        hearingEntities.stream().filter(entity -> HandbellItem.isFriendEntity(pos, entity, player)).forEach(HandbellItem::applyGlowToEntity);
    }

    private static void applyParticlesTooFriends(Level world, BlockPos pos, List<LivingEntity> hearingEntities, Player player) {
        int entiyCount = (int)hearingEntities.stream().filter(entity -> pos.m_203195_((Position)entity.m_20182_(), 48.0)).count();
        hearingEntities.stream().filter(entity -> HandbellItem.isFriendEntity(pos, entity, player)).forEach(entity -> {
            int j = Mth.m_14045_((int)((entiyCount - 21) / -2), (int)3, (int)15);
            for (int k = 0; k < j; ++k) {
                MutableInt mutableInt = new MutableInt(16700985);
                int l = mutableInt.addAndGet(5);
                double h = (double)FastColor.ARGB32.m_13665_((int)l) / 255.0;
                double m = (double)FastColor.ARGB32.m_13667_((int)l) / 255.0;
                double n = (double)FastColor.ARGB32.m_13669_((int)l) / 255.0;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), h, m, n);
            }
        });
    }

    private static void applyGlowToEntity(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120));
    }

    private static boolean isFriendEntity(BlockPos pos, LivingEntity entity, Player player) {
        Allay allay;
        TamableAnimal tamedEntity;
        if (entity instanceof TamableAnimal && (tamedEntity = (TamableAnimal)entity).m_21824_() && tamedEntity.m_21805_().equals(player.m_20148_()) || entity instanceof Allay && (allay = (Allay)entity).m_6274_().m_21952_(MemoryModuleType.f_217778_).isPresent() && player.m_20148_().equals(allay.m_6274_().m_21952_(MemoryModuleType.f_217778_).get())) {
            HandbellItem.teleportEntity(pos, entity, player);
            return true;
        }
        return false;
    }

    private static void teleportEntity(BlockPos pos, LivingEntity entity, Player player) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamedEntity = (TamableAnimal)entity;
            if (player.m_20096_() && !tamedEntity.m_21825_()) {
                tamedEntity.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                tamedEntity.m_21573_().m_26573_();
            }
        }
        if (entity.m_6084_() && !entity.m_213877_()) {
            pos.m_203195_((Position)entity.m_20182_(), 48.0);
        }
    }
}

